% raleigh channel
clear; close all; clc;
%SNR_dB = 40;
%% initialize
Pt_dB=(-10:10:30); %ܹʣdBm-10:10:30
sigma2 = -80; %նΪ-80dBm
SNR_dB = Pt_dB-sigma2;
SNR_linear = 10.^(SNR_dB/10.);%ȶΪܹ/ն
N_iter = 4; % ظʵĴ
M = 4; % number of antennas at BS
N = 32; %number of elements at RIS
N_S = 64; % size of sparse array
K = 4; %number of users
% M=4; N = 8; N_S = 16; K = 2; %Сߴϵͳ㷨
dr = 2;%distance between RIS and user
dd = 50;%distance of direct channel
dg = sqrt(dr^2+dd^2);%distance between BS and RIS
L = 3; %number of multipath

temp_ZF = zeros(N_iter,length(SNR_linear));
temp_S_ZF = zeros(N_iter,length(SNR_linear));
temp_CEO = zeros(N_iter,length(SNR_linear));
temp_S_CEO_improve = zeros(N_iter,length(SNR_linear));
temp_NoRIS = zeros(N_iter,length(SNR_linear));
temp_op = zeros(N_iter,length(SNR_linear));
temp_S_op = zeros(N_iter,length(SNR_linear));

large_fading_AU=3.5; % APUserĴ߶˥ϵ
large_fading_IU=2; % IRSUserĴ߶˥ϵ
large_fading_AI=2; % APIRSĴ߶˥ϵ

%% optimize
for i_iter=1:N_iter
    disp(['i_iter = ', num2str(i_iter)]);
    % channel models
    % beamspace_channel ǺײSVŵ
    % channel ͨ˥ŵ
    % channel_H ǵmatlabʵֵ˥䣨˴߶˥ƽ
    % ֻRISԪйصŵԤ
    G = channel_H(N,M,dg,large_fading_AI,10^(-3));
    Hr = channel_H(K,N,dr,large_fading_IU,10^(-3)); 
    Hd = channel_H(K,M,dd,large_fading_AU,10^(-3));
    %         Hd = beamspace_channel(M,K,L,large_fading_AU,dd).'; % BSûֱŵL=3
    %         Hd = channel(K,M,dd,large_fading_AU); 
    %         G = beamspace_channel(M,N,L,large_fading_AI,dg).'; % BSRISŵL=3
    %         G = channel(N,M,dg,large_fading_AI); % APվIRSŵ
    %         Hr = beamspace_channel(N,K,L,large_fading_IU,dr).'; % RISûŵL=3
    %         Hr = channel(K,N,dr,large_fading_IU); 
    theta0=diag(ones(1,N)); % RISԤ

    % RISϡŲصŵԤ
    G_S = channel_H(N_S,M,dg,large_fading_AI,10^(-3));
    Hr_S = channel_H(K,N_S,dr,large_fading_IU,10^(-3)); 
    %         G_S = beamspace_channel(M,N_S,L,large_fading_AI,dg).';
    %         G_S = channel(N_S,M,dg,large_fading_AI);
    %         Hr_S = beamspace_channel(N_S,K,L,large_fading_IU,dr).'; %ע⣬ɵĲռŵN*KģҪȡת
    %         Hr_S = channel(K,N_S,dr,large_fading_IU); 
    theta_S0=diag(ones(1,N_S));
    
    row_NoRIS=zeros(1,length(SNR_linear)); 
    row_ZF=zeros(1,length(SNR_linear)); % parfor(i)ڲforѭ(j)ܶtemp_ZF(i,j)ֵֻܶtemp_ZF帳ֵ
    row_S_ZF=zeros(1,length(SNR_linear));
    row_CEO=zeros(1,length(SNR_linear));
    row_S_CEO_improve=zeros(1,length(SNR_linear));
    row_op=zeros(1,length(SNR_linear));
    row_S_op=zeros(1,length(SNR_linear));
    
    for i_snr=1:length(SNR_linear)
%         tic
        disp(['i_snr = ', num2str(i_snr)]);
        SNR=SNR_linear(i_snr); 

%% beamforming
%         H2=Hd; W2 = H2'*inv(H2*H2'); H2_eq = H2*W2/norm(W2,'fro');
%         for k=1:K
%             sum_inf=sum(abs(H2_eq(k,:)).^2)-abs(H2_eq(k,k))^2;
%             row_NoRIS(i_snr)=row_NoRIS(i_snr)+log2(1+abs(H2_eq(k,k))^2/(sum_inf+1/SNR));
%         end

        [H,~]=ZF_refine(Hd,G,Hr,theta0,SNR,7);
        for k=1:K
            sum_inf=sum(abs(H(k,:)).^2)-abs(H(k,k))^2;
            row_ZF(i_snr)=row_ZF(i_snr)+log2(1+abs(H(k,k))^2/(sum_inf+1/SNR));
        end
        
        [H_S,~]=ZF_refine_sparse(Hd,G_S,Hr_S,N,theta_S0,SNR,7);
        for k=1:K
            sum_inf=sum(abs(H_S(k,:)).^2)-abs(H_S(k,k))^2;
            row_S_ZF(i_snr)=row_S_ZF(i_snr)+log2(1+abs(H_S(k,k))^2/(sum_inf+1/SNR));
        end

        [D1,~] = CEO_improve3_RIS(Hd,G,Hr,SNR,15);
        for k=1:K
            sum_inf=sum(abs(D1(k,:)).^2)-abs(D1(k,k))^2;
            row_CEO(i_snr)=row_CEO(i_snr)+log2(1+abs(D1(k,k))^2/(sum_inf+1/SNR));
        end
        
        [D1_S_improve,Topo_opt]=CEO_improve_RIS_sparse(Hd,G_S,Hr_S,N,SNR,15);
        for k=1:K
            sum_inf=sum(abs(D1_S_improve(k,:)).^2)-abs(D1_S_improve(k,k))^2;
            row_S_CEO_improve(i_snr)=row_S_CEO_improve(i_snr)+log2(1+abs(D1_S_improve(k,k))^2/(sum_inf+1/SNR));
        end
        
%         [H3,~] = RIS_optimal(Hd,G,Hr,SNR);
%         for k=1:K
%             sum_inf=sum(abs(H3(k,:)).^2)-abs(H3(k,k))^2;
%             row_op(i_snr)=row_op(i_snr)+log2(1+abs(H3(k,k))^2/(sum_inf+1/SNR));
%         end
% 
%         [H4,~,~]=RIS_optimal_sparse(Hd,G_S,Hr_S,N,SNR);
%         for k=1:K
%             sum_inf=sum(abs(H4(k,:)).^2)-abs(H4(k,k))^2;
%             row_S_op(i_snr)=row_S_op(i_snr)+log2(1+abs(H4(k,k))^2/(sum_inf+1/SNR));
%         end                 
 
%         toc   
    end
    temp_NoRIS(i_iter,:) = row_NoRIS;
    temp_ZF(i_iter,:) = row_ZF;
    temp_S_ZF(i_iter,:) = row_S_ZF;
    temp_CEO(i_iter,:) = row_CEO;
    temp_S_CEO_improve(i_iter,:) = row_S_CEO_improve;
    temp_op(i_iter,:) = row_op;
    temp_S_op(i_iter,:) = row_S_op;
end

rate_NoRIS = sum(temp_NoRIS,1)/N_iter; % ά1*length(SNR_linear)
rate_ZF = sum(temp_ZF,1)/N_iter;
rate_CEO = sum(temp_CEO,1)/N_iter;
rate_S_ZF = sum(temp_S_ZF,1)/N_iter;
rate_S_CEO_improve = sum(temp_S_CEO_improve,1)/N_iter;
rate_op = sum(temp_op,1)/N_iter;
rate_S_op = sum(temp_S_op,1)/N_iter;

save temp_SNR_4M32N64Ns4K.mat

%% figure
markS = 6; LineW =1.5;
% plot(Pt_dB,rate_NoRIS,'o-.k','MarkerSize',markS,'Linewidth',LineW);
hold on
plot(Pt_dB,rate_ZF,'--dk','MarkerSize',markS,'Linewidth',LineW);
plot(Pt_dB,rate_CEO,'^-m','MarkerSize',markS,'Linewidth',LineW);
% plot(Pt_dB,rate_op,'-pc','MarkerSize',markS,'Linewidth',LineW);
plot(Pt_dB,rate_S_ZF,'s--b','MarkerSize',markS,'Linewidth',LineW);
plot(Pt_dB,rate_S_CEO_improve,'v-r','MarkerSize',markS,'Linewidth',LineW);
% plot(Pt_dB,rate_S_op,'-pb','MarkerSize',markS,'Linewidth',LineW);
% (1:end-1)
% legend('Without RIS','Traditional RIS based scheme','Proposed irregular RIS based scheme');
% legend('Without RIS','CEO with RIS','CEO with irregular RIS','improved CEO with irregular RIS');
% legend('Without RIS','ZF refinement with RIS','CEO with RIS','sparse design by ZF','sparse design by CEO');
% legend('Traditional scheme by SR','Traditional scheme by NCE','Optimal solution of traditional scheme',...
%     'Irregular scheme by SR','Irregular scheme by NCE','Optimal solution of irregular scheme');
legend('Traditional regular RIS-based scheme by SR','Traditional regular RIS-based scheme by NCE',...
    'Proposed irregular RIS-based scheme by SR','Proposed irregular RIS-based scheme by NCE');
xlabel('Transmit power (dBm)')
ylabel('Weighted sum-rate (bit/s/Hz)')
box on;
grid on

% over