% raleigh channel
clear; close all; clc;
%% N̶RISߴN_s
Pt_dB = 10; % ̶书Ϊ10dBmоʺRISϡȵĹϵ
N = 20; %number of elements at RIS
N_S_linear = (20:20:120); % different size of sparse array, 20:20:120
N_iter=4; % ظʵĴ
%% initialize
sigma2 = -80; %նΪ-80dBm
SNR_dB = Pt_dB-sigma2;
SNR=10.^(SNR_dB/10.);%ǽն˵
M = 4; % number of antennas at BS
K = 4; %number of users
dr = 2;%distance between RIS and user
dd = 50;%distance of direct channel
dg = sqrt(dr^2+dd^2);%distance between BS and RIS
L = 3; %number of multipath

temp_CEO = zeros(N_iter,length(N_S_linear));
temp_S_CEO_improve = zeros(N_iter,length(N_S_linear));

large_fading_AU=3.5; % APUserĴ߶˥ϵ
large_fading_IU=2; % IRSUserĴ߶˥ϵ
large_fading_AI=2; % APIRSĴ߶˥ϵ

%% optimize
parfor i_iter=1:N_iter 
    disp(['i_iter = ', num2str(i_iter)]);
    % channel models: RISߴN_S޹صŵ
    % beamspace_channel ǺײSVŵ
    % channel ͨ˥ŵ
    % channel_H ǵmatlabʵֵ˥䣨˴߶˥ƽ
    G = channel_H(N,M,dg,large_fading_AI,10^(-3));
    Hr = channel_H(K,N,dr,large_fading_IU,10^(-3)); 
    Hd = channel_H(K,M,dd,large_fading_AU,10^(-3));
    row_CEO=zeros(1,length(N_S_linear));
    row_S_CEO_improve=zeros(1,length(N_S_linear)); 
    
    for i_N_S=1:length(N_S_linear)
        tic
        disp(['i_N_S = ', num2str(i_N_S)]);
        N_S=N_S_linear(i_N_S); 
       
        % channel models: RISϡŲߴN_Sйأŵ
        G_S = channel_H(N_S,M,dg,large_fading_AI,10^(-3));
        Hr_S = channel_H(K,N_S,dr,large_fading_IU,10^(-3)); 
%         G_S = beamspace_channel(M,N_S,L,large_fading_AI,dg).';
%         G_S = channel(N_S,M,dg,large_fading_AI);
%         Hr_S = beamspace_channel(N_S,K,L,large_fading_IU,dr).'; %ע⣬ɵĲռŵN*KģҪȡת
%         Hr_S = channel(K,N_S,dr,large_fading_IU); 

%% beamforming
        if N_S==N
            [D1,~] = CEO_improve3_RIS(Hd,G,Hr,SNR,15);
            for k=1:K
                sum_inf=sum(abs(D1(k,:)).^2)-abs(D1(k,k))^2;
                row_CEO(i_N_S)=row_CEO(i_N_S)+log2(1+abs(D1(k,k))^2/(sum_inf+1/SNR));
            end
        else
            [D1_S_improve,~]=CEO_improve_RIS_sparse(Hd,G_S,Hr_S,N,SNR,15);
            for k=1:K
                sum_inf=sum(abs(D1_S_improve(k,:)).^2)-abs(D1_S_improve(k,k))^2;
                row_S_CEO_improve(i_N_S)=row_S_CEO_improve(i_N_S)+log2(1+abs(D1_S_improve(k,k))^2/(sum_inf+1/SNR));
            end
        end
        
    toc
    end
    
    temp_CEO(i_iter,:)=row_CEO;
    temp_S_CEO_improve(i_iter,:)=row_S_CEO_improve;
end

temprate_CEO = sum(temp_CEO,1)/N_iter;
temprate_S_CEO_improve = sum(temp_S_CEO_improve,1)/N_iter;
rate_CEO = temprate_CEO(1)*ones(1,length(N_S_linear));

% վ仯ĶԱߣ10000ظʵ
% rate_CEO = 13.8865*ones(1,length(sparse_degree)); % rate_4M
rate_6M = 16.7360*ones(1,length(sparse_degree));
rate_7M = 17.6852*ones(1,length(sparse_degree));
rate_8M = 18.4594*ones(1,length(sparse_degree));

rate_S_CEO_improve = [rate_CEO(1), temprate_S_CEO_improve(2:end)];
% sparse_degree = [N/N, N./N_S_linear];
sparse_degree = N_S_linear;

save temp_size_10dBm_2-2-3.5-30-80.mat;

%% figure
markS = 6; LineW =1.5;
hold on
plot(sparse_degree,rate_S_CEO_improve,'v-r','MarkerSize',markS,'Linewidth',LineW);
plot(sparse_degree,rate_CEO,'^-m','MarkerSize',markS,'Linewidth',LineW);
plot(sparse_degree,rate_6M,'--b','MarkerSize',markS,'Linewidth',LineW);
plot(sparse_degree,rate_7M,'-.b','MarkerSize',markS,'Linewidth',LineW);
plot(sparse_degree,rate_8M,'-b','MarkerSize',markS,'Linewidth',LineW);

% legend('Proposed irregular RIS-based scheme','Traditional RIS-based scheme');
% legend('without RIS','improved CEO with RIS','improved CEO with irregular RIS');
legend('Proposed irregular RIS-based scheme, M=4','Traditional regular RIS-based scheme, M=4','Traditional regular RIS-based scheme, M=6',...
    'Traditional regular RIS-based scheme, M=7','Traditional regular RIS-based scheme, M=8');
% legend('without RIS','ZF refinement with RIS','CEO with RIS','sparse design by ZF','sparse design by CEO')%,'ZF refinement with RIS_2bit');
% legend('ZF refinement with RIS','CEO with RIS1bit','without RIS','CEO with RIS_2bit')%,'ZF refinement with RIS_2bit');
xlabel('Size of the irregular RIS')
ylabel('Weighted sum-rate (bit/s/Hz)')
set(gca,'ytick',13.5:0.5:19.5); 
ylim([13.5 19.5]);
box on;
grid on

% over