function [H_eq_S,theta_opt] = ZF_refine_sparse(Hd,G_S,Hr_S,N,theta0,SNR,iter)
K = size(Hd,1);
N_S = size(G_S,1);
Topo = rand(1,N_S);
temp = sort(Topo);
Topo(Topo<=temp(N)) = 1;
Topo(Topo~=1) = 0;
iteration = 40; % iterations
neighsize = 15; % the number of neighbours to be searched each time
% if N_S<64
%     neighmove = 2;
% elseif N_S<160
neighmove = 3;
% else
%     neighmove = 4; % the number of move pairs
% end
Cmax = -inf;
ZF_RateSparse = zeros(1,iteration);
tag = 0;
for i = 1:iteration % ϡṹiterations
%     if mod(i,10) == 0
%         disp(['ZF_TS : ', num2str(i)]); 
%     end
    if tag==0 && i>iteration/2
        neighmove = neighmove-1; % adaptively change the number of move pairs
        tag = 1;
    end
    C = zeros(1,neighsize);
    theta = zeros(N_S,N_S,neighsize);
    Topo_neigh = zeros(N_S,neighsize); % save the neighbours
    for j = 1:neighsize % 
        Topo_temp = Topo;
        index1 = find(Topo==1);
        ind1 = randperm(length(index1),neighmove); % choose "neighmove" numbers to be exchanged
        index0 = find(Topo==0);
        ind0 = randperm(length(index0),neighmove);
        Topo_temp(index1(ind1)) = 0; % exchange 0 with 1 
        Topo_temp(index0(ind0)) = 1;
        Topo_neigh(:,j) = Topo_temp; % save the neigh
        sw = diag(Topo_temp);
        
        % ZF refine algorithm ָϡṹԤ
        theta1 = theta0;
        for u =1:iter
            H_S = Hr_S*sw*theta1*G_S+Hd;
            for v=1:N_S
                if sw(v,v) == 1
                    W=H_S'*inv(H_S*H_S');
                    H_ef = H_S*W/norm(W,'fro'); %վԤŵܵЧŵ
                    temp = 0;
                    for kk=1:K
                        sum_inf=sum(abs(H_ef(kk,:)).^2)-abs(H_ef(kk,kk))^2;
                        temp=temp+log2(1+abs(H_ef(kk,kk))^2/(sum_inf+1/SNR));
                    end
                    c1=temp;
                    
                    theta1(v,v)=-1;
                    H_S = Hr_S*sw*theta1*G_S+Hd;
                    W=H_S'*inv(H_S*H_S');
                    H_ef = H_S*W/norm(W,'fro'); %վԤŵܵЧŵ
                    temp = 0;
                    for kk=1:K
                        sum_inf=sum(abs(H_ef(kk,:)).^2)-abs(H_ef(kk,kk))^2;
                        temp=temp+log2(1+abs(H_ef(kk,kk))^2/(sum_inf+1/SNR));
                    end
                    c2=temp;
                    
                    if c1>c2
                        theta1(v,v)=1;
                    end
                end
            end
        end
        % ZF refine algorithm
        
        theta(:,:,j) = theta1;
        H_S = Hr_S*sw*theta1*G_S+Hd;
        W=H_S'*inv(H_S*H_S');
        H_ef = H_S*W/norm(W,'fro'); %վԤŵܵЧŵ
        temp = 0;
        for kk=1:K
            sum_inf=sum(abs(H_ef(kk,:)).^2)-abs(H_ef(kk,kk))^2;
            temp=temp+log2(1+abs(H_ef(kk,kk))^2/(sum_inf+1/SNR));
        end
        C(j)=temp;              
    end %
    
    [ZF_RateSparse(i),num] = max(C); % save the optimal mainlobe of each iteration
    Topo = Topo_neigh(:,num); % the next iteration input
    % search the global optimal and save as Topo_opt
%     disp(Power(i));
    if ZF_RateSparse(i) > Cmax
        Cmax = ZF_RateSparse(i);
        Topo_opt = Topo;
        theta_opt = theta(:,:,num);
    end
    
end %ϡṹ

ZF_RateSparse_max = Cmax
ZF_RateSparse
H_S = Hr_S*diag(Topo_opt)*theta_opt*G_S+Hd;
W=H_S'*inv(H_S*H_S');
H_eq_S = H_S*W/norm(W,'fro'); %վԤŵܵЧŵ
