function  at = array_steering_vector( N1, N2, d, lambda, theta, phi)
    n1 = ( -(N1-1)/2:1:(N1-1)/2 )';
    n2 = ( -(N2-1)/2:1:(N2-1)/2 )';
    a1 = exp(1j*2*pi*n1*d*sin(theta)*cos(phi)/lambda);
    a2 = exp(1j*2*pi*n2*d*sin(phi)/lambda);
    at = kron(a1, a2)/sqrt(N1*N2);
end

