function RAQR_config = configureRAQR(category)
% This file returns basic RAQR configuration structure. 
% Category: "Normal", "Transit", "DualBand" 
% 

if ~exist("category", "var")
    category = "Normal"; 
end

    RAQR_config.d   = 2e-2;                     % 2cm
    RAQR_config.N0  = (4.89e10)*(1e6);          % number of atoms per m^3 
    
    RAQR_config.Delta_p = 2*pi*2e1; 
    RAQR_config.Delta_c = 2*pi*-3e1;            % Coupling laser detuning, match LO

    
    RAQR_config.gamma   = 0;
    RAQR_config.gamma_2 = 2*pi*5.2e6; 
    RAQR_config.gamma_3 = 2*pi*3.9e3; 
    RAQR_config.gamma_4 = 2*pi*1.7e3; 
    RAQR_config.gamma_c = 0; 
    
    % (Nature Physics, 2020)
    % RAQR_config.Omega_c     = 2*pi*0.97e6;              % coupling beam 17.0mW  @ 510nm
    % RAQR_config.Omega_p     = 2*pi*5.7e6;               % probe    beam 29.8uW  @ 852nm
    
    % RAQR_config.Omega_c     = 2*pi*4.0e6;                 % These two values are related to the beam intensity and transition dipoles. 
    % RAQR_config.Omega_p     = 2*pi*2.0e6;
    
    % (2019)
    RAQR_config.Omega_c     = 2*pi*2.05e6;
    RAQR_config.Omega_p     = 2*pi*8.08e6; 
    
    RAQR_config.lambda_c    = 510e-9; 
    RAQR_config.lambda_p    = 852e-9; 

    RAQR_config.eta         = 0.8;      % Photodiode quantum efficiency  


    if category == "Normal"
        RAQR_config.A_LO    = 0.04;     % MW LO strength [V/m] 
        RAQR_config.Delta_l = 2*pi*1e1; 

    elseif category == "Transit"
        RAQR_config.A_LO    = 0.5;      % This value is 3mV/cm 
        RAQR_config.w_p     = 1.70e-3; 
        RAQR_config.Delta_l = 2*pi*1e1; 

        RAQR_config.Temperature = 300; 

        NA                  = 6.02e23; 
        M_Cs                = 132.9; 
        m_Cs                = (M_Cs/1e3)/NA; 
        RAQR_config.m_Cs    = m_Cs; 

        kB = getPhysicalConstant("Boltzmann"); 
        RAQR_config.gamma   = sqrt(8*kB*RAQR_config.Temperature/(pi*m_Cs)) / ...
                                (RAQR_config.w_p*sqrt(2*log(2))); 

    elseif category == "DualBand"
        RAQR_config.A_LO1       = 0.04; 
        RAQR_config.A_LO2       = 0.04; 
        RAQR_config.Delta_l1    = 2*pi*1e1; 
        RAQR_config.Delta_l2    = 2*pi*2e1; 
        RAQR_config.gamma_5     = 2*pi*5.0e3; 
    end
    
end

