function [gI1, gQ1, gI2, gQ2, success] = findTransferFunctionFile(hashString, findPath)
    matFiles = dir(fullfile(findPath, '*.mat')); 
    
    for k = 1:numel(matFiles)
        fileName    = matFiles(k).name; 
        fullPath    = fullfile(findPath, fileName); 
        data        = load(fullPath); 
        if isfield(data, 'hashString')  
            if data.hashString == hashString
                gI1 = data.gI1; 
                gQ1 = data.gQ1; 
                gI2 = data.gI2; 
                gQ2 = data.gQ2; 
                success = true; 
                return; 
            end
        end
    end

    gI1 = -1; 
    gQ1 = -1; 
    gI2 = -1; 
    gQ2 = -1; 
    success = false; 

end