function [C, p] = getAnalyticalODESolution(A, x0)
% dx/dt = Ax with initial condition x0

    [n, ~] = size(A); 
    C = zeros(n, n); p = zeros(1, n); 
    [V, D] = eig(A); 
    
    p = diag(D); 

    w = V\x0; 
    for idx = 1:n
        C(:, idx) = V(:, idx)*w(idx); 
    end

end

