function [Lambdas, R, L] = getEigenDecomposition(G)
    [R, D]      = eig(G); 
    [~, order]  = sort(abs(diag(D)), 'ascend'); 
    
    R           = R(:, order); 
    d           = diag(D); 
    Lambdas     = d(order); 
    
    % G*R = R*diag(Lambdas)
    L = inv(R);     % Left eigen-vectors, arranged in row vectors  
end
