function Jval = getJ(z_arr)
% This function returns the Hilbert transform of a standard Gaussian
% distribution. We may encounter problems when the argument z is too large.
% 

    assert(isrow(z_arr)); 
    Nz      = length(z_arr); 
    Jval    = zeros(1, Nz); 
    
    for idx = 1:Nz
        z           = z_arr(idx); 
        Jval(idx)   = (1/sqrt(2*pi))*exp(-z^2/2)* (pi*erfi(z/sqrt(2)) - 1i*pi*sign(imag(z)));  
    end

    
end

