function [gI1, gQ1, gI2, gQ2] = getQuantumTransConductanceTFs(RAQR_config, tf_filename)

    if exist('tf_filename', 'var')
        load(sprintf("%s", tf_filename), "tfI", "tfQ"); 
    else
        [tfI, tfQ] = getPerturbationTransferFunctions(RAQR_config, RAQR_config.A_LO); 
    end

    GI1 = tf(real(tfI.Numerator{1}), tfI.Denominator{1});   
    GI2 = tf(imag(tfI.Numerator{1}), tfI.Denominator{1}); 
    GQ1 = tf(real(tfQ.Numerator{1}), tfQ.Denominator{1}); 
    GQ2 = tf(imag(tfQ.Numerator{1}), tfQ.Denominator{1}); 
    
    e           = 1.6e-19; 
    a0          = 5.2918e-11; 
    kp          = 2*pi/(852e-9); 
    N0          = (4.89e10)*(1e6);
    epsilon_0   = 8.85e-12;
    mu_MW       = 1443.45*e*a0; 
    mu_12       = 4.5022*e*a0; 
    hbar        = 6.626e-34 / (2*pi); 
    c0          = physconst('LightSpeed');
    
    Omega_p     = RAQR_config.Omega_p; 
    
    
    % load("minors.mat", "x_steady"); 
    [rho_steady, ~]     = getSteadySolution(RAQR_config, RAQR_config.A_LO); 
    


    alpha_0             = -(kp*N0*(mu_12^2))/(epsilon_0*hbar*Omega_p)*imag(rho_steady(2,1));
    P_probe             = 29.8e-6; 
    probeTransmission   = exp(-2*alpha_0*RAQR_config.d); 
    
    % Compute the kappa factor that often appear in the literature. 
    kappa = P_probe*probeTransmission*(2*(kp*N0*(mu_12^2))/(epsilon_0*hbar*Omega_p)) * (RAQR_config.d*dcgain(GI2)); 
    fprintf('DC kappa factor [W/Hz] = '); disp(kappa);  
    
    
    Iph0    = (RAQR_config.eta*P_probe)/(hbar*(c0*kp))*e*probeTransmission; 
    GainAdj = 2*kp*N0*(mu_12)^2/(epsilon_0*hbar*Omega_p) * Iph0 * (mu_MW/2/hbar); 

    % Return all the gain coefficients with g(s) = b(s)/a(s) 
    gI1.b = GainAdj*GI1.Numerator{1}; 
    gI1.a = GI1.Denominator{1};

    gQ1.b = GainAdj*GQ1.Numerator{1}; 
    gQ1.a = GQ1.Denominator{1};

    gI2.b = GainAdj*GI2.Numerator{1}; 
    gI2.a = GI2.Denominator{1};

    gQ2.b = GainAdj*GQ2.Numerator{1}; 
    gQ2.a = GQ2.Denominator{1};

end
