(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      5223,        178]
NotebookOptionsPosition[      4306,        147]
NotebookOutlinePosition[      4663,        163]
CellTagsIndexPosition[      4620,        160]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"z", "-", "x"}], ")"}]}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", " ", "\[Pi]"}], "]"}]}], "*", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "/", "2"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966983938491743*^9, 
  3.9669839844003296`*^9}},ExpressionUUID->"e8c18b29-8388-4b4f-9dd0-\
28a78b9811f0"],

Cell[BoxData[
 RowBox[{"ConditionalExpression", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["z", "2"], "2"]}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Pi]", " ", 
        RowBox[{"Erfi", "[", 
         FractionBox["z", 
          SqrtBox["2"]], "]"}]}], "-", 
       RowBox[{"Log", "[", 
        RowBox[{"-", 
         FractionBox["1", "z"]}], "]"}], "-", 
       RowBox[{"Log", "[", "z", "]"}]}], ")"}]}], 
    SqrtBox[
     RowBox[{"2", " ", "\[Pi]"}]]], ",", 
   RowBox[{
    RowBox[{"Im", "[", "z", "]"}], "\[NotEqual]", "0"}]}], "]"}]], "Output",
 CellChangeTimes->{
  3.966983986904225*^9},ExpressionUUID->"e01e8538-f606-4bfc-a0ac-\
83efa5f9a7cd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Gamma", "[", 
  RowBox[{"1", "/", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.9669967985046153`*^9, 
  3.9669968006901884`*^9}},ExpressionUUID->"c564f7a3-5c4b-4ae1-a24d-\
8f0c10c3aecb"],

Cell[BoxData[
 SqrtBox["\[Pi]"]], "Output",
 CellChangeTimes->{
  3.966996801338707*^9},ExpressionUUID->"bbd89fb5-c5ff-4e13-8013-\
6fbe0ab99289"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"Pi", "/", "2"}], "]"}], "*", 
     RowBox[{"Erfi", "[", 
      FractionBox["z", 
       SqrtBox["2"]], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "\[Infinity]", ",", "5"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.966997091671607*^9, 3.9669971090922747`*^9}, {
  3.966997202953453*^9, 3.966997214353222*^9}, {3.9669972523533792`*^9, 
  3.966997284178438*^9}, {3.9669973461878033`*^9, 3.9669973511082735`*^9}, {
  3.9669974078420553`*^9, 3.9669974223132243`*^9}, {3.966997454417369*^9, 
  3.9669974590973005`*^9}, {3.966997564081921*^9, 
  3.966997571713911*^9}},ExpressionUUID->"ad29e3d3-3d9e-470d-aa78-\
f7cf0a9767d6"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]]}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    FractionBox[
     SuperscriptBox["z", "2"], "2"]], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox["1", "z"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "z"], ")"}], "3"], "+", 
      FractionBox["3", 
       SuperscriptBox["z", "5"]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "z"], "]"}], "6"],
       SeriesData[$CellContext`z, 
        DirectedInfinity[1], {}, 1, 6, 1],
       Editable->False]}],
     SeriesData[$CellContext`z, 
      DirectedInfinity[1], {1, 0, 1, 0, 3}, 1, 6, 1],
     Editable->False], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.966997284525251*^9, {3.9669973524720297`*^9, 3.966997373293499*^9}, {
   3.9669974092583394`*^9, 3.966997422669777*^9}, 3.966997459723942*^9, 
   3.9669975723741975`*^9},ExpressionUUID->"dea4699e-c12d-4bde-a39d-\
277fd496add0"]
}, Open  ]]
},
WindowSize->{847, 721},
WindowMargins->{{Automatic, 570}, {98, Automatic}},
FrontEndVersion->"11.1 for Microsoft Windows (64-bit) (2017\:5e745\:670816\
\:65e5)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 619, 20, 47, "Input", "ExpressionUUID" -> \
"e8c18b29-8388-4b4f-9dd0-28a78b9811f0"],
Cell[1202, 44, 777, 25, 87, "Output", "ExpressionUUID" -> \
"e01e8538-f606-4bfc-a0ac-83efa5f9a7cd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2016, 74, 211, 5, 47, "Input", "ExpressionUUID" -> \
"c564f7a3-5c4b-4ae1-a24d-8f0c10c3aecb"],
Cell[2230, 81, 145, 4, 66, "Output", "ExpressionUUID" -> \
"bbd89fb5-c5ff-4e13-8013-6fbe0ab99289"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2412, 90, 783, 19, 76, "Input", "ExpressionUUID" -> \
"ad29e3d3-3d9e-470d-aa78-f7cf0a9767d6"],
Cell[3198, 111, 1092, 33, 72, "Output", "ExpressionUUID" -> \
"dea4699e-c12d-4bde-a39d-277fd496add0"]
}, Open  ]]
}
]
*)

