## 指导思想

要做教科书级别的工作。要保证工作的正确性、严格性，保证理论与算法具有持久的生命力。




- 给定LO，如何计算缀饰态（dressed state）对external signal的响应？
- 如何检测QPSK信号？（已经解决）
- 黑体辐射噪声的计算，如何整合到量子模型中？（这是理论的主要贡献）
- 综合设计一个OFDM系统，并进行模拟（仿真）的传输实验。



## Master equation 

The time-varying Hamiltonian is given by 
$$
{\bf H}(t) = \begin{bmatrix} 0 & \frac{\Omega_p}{2} & 0 & 0 \\ 
\frac{\Omega_p}{2} & \Delta_p & \frac{\Omega_c}{2} & 0 \\ 
0 & \frac{\Omega_c}{2} & \Delta_p+\Delta_c & \frac{\Omega_{\rm LO} + \Omega_{\rm Sig}e^{-i2\pi f_{\rm IF}t}A(t)}{2} \\ 
0 & 0 & \frac{\Omega_{\rm LO} + \Omega_{\rm Sig}e^{i2\pi f_{\rm IF}t}A(t)}{2} & \Delta_p+\Delta_c+\Delta_\ell \end{bmatrix}
$$
where the Hamiltonian is written under basis 
$$
\psi(t) = \sum_{k=1}^4 c_k(t) e^{-i\omega_k t}\ket{k}
$$
Assume that the sig frequency is higher than LO. The external MW field is written as 
$$
\begin{aligned}
{E}(t) &= E_{\rm LO}(t) + E_{\rm Sig}(t) \\ &= A_{\rm LO}\cos(\omega_{\rm LO}t) + A_{\rm Sig}\left[I(t)\cos(2\pi (f_{\rm IF}+f_{\rm LO})t)-Q(t)\sin(2\pi (f_{\rm IF}+f_{\rm LO})t) \right]
\end{aligned}
$$
The (3,4)-element will be beated with $e^{i(\omega_3-\omega_4)t}$ term. The low-freq term is given by  the following, after rotational wave approximation. ($A_{\rm Sig}\ll A_{\rm LO}$) 
$$
[{\bf H}]_{34} = \frac{\mu_{\rm MW}\cdot A_{\rm LO}}{2\hbar} + \frac{\mu_{\rm MW}\cdot A_{\rm Sig}}{2\hbar}e^{-i2\pi f_{\rm IF}t} \left(I(t) - iQ(t) \right)
$$

$$
[{\bf H}]_{43} = \frac{\mu_{\rm MW}\cdot A_{\rm LO}}{2\hbar} + \frac{\mu_{\rm MW}\cdot A_{\rm Sig}}{2\hbar}e^{i2\pi f_{\rm IF}t}(I(t)+iQ(t))
$$

We generally assume that the baseband signal is 
$$
x_{\rm BB}(t) := I_{\rm BB}(t)+iQ_{\rm BB}(t) = e^{i2\pi f_{\rm IF}t}(I(t)+iQ(t))
$$
and the s-domain representation is 
$$
X_{\rm BB}(s) = \int_{0-}^\infty x_{\rm BB}(\tau)e^{-s\tau}{\rm d}\tau,\quad s\in\mathbb{C}. 
$$
Note that the baseband subscription is used when $f_{\rm IF}=0$. If $f_{\rm IF}\neq 0$, we use $I(t)+iQ(t)$ instead. 



In the Rydberg setting $\ket{1},\ket{2},\ket{3},\ket{4}$ which satisfies 

- Conjecture: The signs of the three off-diagonal Hamiltonian elements do not matter under substitution $\ket{1}\to -\ket{1} $ and $\ket{4}\to -\ket{4}$. 


Another paper on EIT defines the Hamiltonian to be 
$$
H_0 = \frac{1}{2} \begin{bmatrix}0 & \Omega_p & 0 & 0 \\
\Omega_p & -2\Delta_p & \Omega_c & 0 \\
0 & \Omega_c & -2(\Delta_p+\Delta_c) & \Omega_{\rm RF}^* \\ 
0 & 0 & \Omega_{\rm RF} & -2(\Delta_p +\Delta_c - \Delta_{\rm RF})
\end{bmatrix}
$$
where the four atomic levels can be seen from this Hamiltonian. This contradicts with the statements in [arXiv 2024, T. Gong] in that the diagonal elements cannot be replaced by their opposite values. The detuning values are defined as usual, where a positive detuning means that the light/MW has a higher frequency than the atomic resonance. 



- Steady-state solution, is this possible? 

We wish to find the steady-state solution to the density matrix $\rho$, given ${\bf H}$ and the decay rates $\gamma_i$. The Lindblad master equation is 
$$
\frac{{\rm d}\rho}{{\rm d}t} = -i[H,\rho] + D[\rho]
$$
where 
$$
D[\rho] = -\frac{1}{2}({\bf \Gamma}\rho+\rho{\bf \Gamma}) + {\rm diag}(\gamma_2 \rho_{22} + \gamma_4 \rho_{44}, \gamma_3\rho_{33}, 0, 0)
$$

$$
{\bf \Gamma} = {\rm diag}(0, \gamma_2, \gamma_3, \gamma_4)
$$

We note that ${\rm tr}[D[\rho]] = 0$, indicating that ${\rm tr}\rho\equiv 1$ is satisfied during evolution. 

The steady-state solution is given by solving the RHS linear equation of the RHS of the master equation. We can use Mathematica to help us do this thing. 

We write the complete form of $D[\rho]$ here: 
$$
D[\rho] = \begin{bmatrix} 
\gamma_2\rho_{22} + \gamma_4 \rho_{44} & -\frac{\gamma_2}{2}\rho_{12} & -\frac{\gamma_3}{2}\rho_{13} & -\frac{\gamma_4}{2}\rho_{14} \\ 
-\frac{\gamma_2}{2}\rho_{21} & \gamma_3 \rho_{33} -\gamma_2\rho_{22} & -\frac{\gamma_{23}}{2}\rho_{23} & -\frac{\gamma_{24}}{2}\rho_{24} \\ 
-\frac{\gamma_3}{2}\rho_{31} & -\frac{\gamma_{23}}{2}\rho_{32} & -\gamma_3 \rho_{33} & -\frac{\gamma_{34}}{2}\rho_{34} \\ 
-\frac{\gamma_4}{2}\rho_{41} & -\frac{\gamma_{24}}{2}\rho_{42} & -\frac{\gamma_{34}}{2}\rho_{43} & -\gamma_4\rho_{44} 
\end{bmatrix}
$$
Re-write in terms of $\rho_{21}, \rho_{31}, \rho_{41}$, we get

The lower off-diagonal elements are given by 
$$
\frac{d\rho_{21}}{dt} = -i\left( \frac{\Omega_p}{2} \rho_{11} - \Delta_p \rho_{21} + \frac{\Omega_c}{2}\rho_{31}-\frac{\Omega_p}{2}\rho_{22}\right) + D[\rho]_{21}
$$

$$
\frac{d\rho_{31}}{dt} = -i\left(\frac{\Omega_c}{2}\rho_{21}-(\Delta_p+\Delta_c)\rho_{31}+\frac{\Omega_{\rm RF}}{2}\rho_{41} - \frac{\Omega_p}{2}\rho_{32}\right) + D[\rho]_{32}
$$

$$
\frac{d\rho_{41}}{dt} = -i\left(\frac{\Omega_{\rm RF}^*}{2}\rho_{31}-(\Delta_p+\Delta_c+\Delta_{\rm RF})\rho_{41}-\frac{\Omega_p}{2}\rho_{42}\right) + D[\rho]_{32}
$$

$$
\frac{d\rho_{32}}{dt} = -i\left( \frac{\Omega_c}{2}\rho_{22}-\Delta_c\rho_{32}+\frac{\Omega_{\rm RF}}{2}\rho_{42}-\frac{\Omega_p}{2}\rho_{31}-\frac{\Omega_c}{2}\rho_{33}\right)+D[\rho]_{32}
$$

$$
\frac{d\rho_{42}}{dt} = -i\left(\frac{\Omega_{\rm RF}^*}{2}\rho_{32}-(\Delta_c+\Delta_{\rm RF})\rho_{42} - \frac{\Omega_p}{2}\rho_{41}-\frac{\Omega_c}{2}\rho_{43}\right)+D[\rho]_{42}
$$

$$
\frac{d\rho_{43}}{dt} = -i\left(\frac{\Omega_{\rm RF}^*}{2}\rho_{33}-\Delta_{\rm RF}\rho_{43}-\frac{\Omega_c}{2}\rho_{42}-\frac{\Omega_{\rm RF}^*}{2}\rho_{44}\right)+D[\rho]_{43}
$$



The on-diagonal elements are given by 
$$
\frac{d\rho_{11}}{dt} = i\frac{\Omega_p}{2}(\rho_{12}-\rho_{21})+D[\rho]_{11}
$$

$$
\frac{d\rho_{22}}{dt} = -i\left(\frac{\Omega_p}{2}(\rho_{12}-\rho_{21})-\frac{\Omega_c}{2}(\rho_{23}-\rho_{32})\right) + D[\rho]_{22}
$$

$$
\frac{d\rho_{33}}{dt} = -i\left(\frac{\Omega_c}{2}(\rho_{23}-\rho_{32}+\frac{\Omega_{\rm RF}}{2}\rho_{43}-\frac{\Omega_{RF}^*}{2}\rho_{34})\right)+D[\rho]_{33}
$$

$$
\frac{d\rho_{44}}{dt} = -i\left(\frac{\Omega_{\rm RF}^*}{2}\rho_{34}-\frac{\Omega_{\rm RF}}{2}\rho_{43}\right)+D[\rho]_{44}
$$

$\Im[\rho_{21}], \Im[\rho_{32}], \Im[\rho_{43}]$ are linearly related to $\rho_{11}, \cdots, \rho_{44}$. 



We wish to find the steady state solution of $\rho_{21}$, as a function of all the parameters. Let
$$
{\bf f} = (\rho_{21}, \rho_{31}, \rho_{41}, \rho_{32},\rho_{42}, \rho_{43})^\mathsf{T}
$$
then we get 
$$
\partial_t {\bf f} = -i{\bf B}{\bf f} + {\bf C}{\bf d},
$$
where ${\bf d} = (\rho_{11}-\rho_{22}, \rho_{22}-\rho_{33}, \frac{\Omega_{\rm RF}}{2}(\rho_{33}-\rho_{44}))$, ${\bf B}$ and $\bf C$ are some constant matrices. Thus, the on-diagonal elements of $\rho$ determines its off-diagonal steady-state elements.  



Suppose we have obtained the steady-state solution. Another important topic is to obtain the impulse response of $\rho_{21}(t)$ w.r.t. a delta-impulse in $E_{\rm Sig}(t)$. 



## ODE Perturbation Theorem

Without loss of generality, let us assume a linear system 
$$
\frac{{\rm d}{\bf x}_{\epsilon}}{{\rm d}t} = ({\bf A}_0+\epsilon {\bf A}_1(t)){\bf x}_{\epsilon}(t)	+ {\bf b}
$$
with a stable ${\bf A}_0$ ($\Re[\lambda({\bf A}_0)] < 0$) and some small time-varying perturbation $\epsilon{\bf A}_1(t)$. We want to evaluate $\partial {\bf x}_\epsilon/\partial\epsilon$, such that the perturbed solution is approximated by the original solution plus $\epsilon$ times some first-order derivative. 
$$
{\bf x}_\epsilon(t) = {\bf x}_0(t)+\epsilon \frac{\partial {\bf x}_\epsilon}{\partial\epsilon} + o(\epsilon)
$$
Substitute this perturbed solution into the ODE, we get
$$
\frac{{\rm d}{\bf x}_0(t)}{{\rm d}t} + \epsilon \frac{\partial^2{\bf x_\epsilon}}{\partial t \partial \epsilon} + o(\epsilon) = {\bf A}_0 {\bf x}_0(t)+{\bf b} + \epsilon ({\bf A}_1(t){\bf x}_0(t)+{\bf A}_0\frac{\partial {\bf x}_\epsilon}{\partial\epsilon})+o(\epsilon)
$$
We know that ${\rm d}{\bf x}_0/{\rm d}t={\bf A}_0{\bf x}_0+{\bf b}$, so we arrive at 
$$
\partial_t(\frac{\partial {\bf x}_\epsilon}{\partial\epsilon}) = {\bf A}_1(t){\bf x}_0(t) + {\bf A}_0 (\frac{\partial {\bf x}_\epsilon}{\partial\epsilon})
$$
If we let ${\bf y}(t) = \partial {\bf x}_\epsilon/\partial\epsilon$, we get
$$
\partial_t {\bf y} - {\bf A_0}{\bf y} = {\bf A_1}(t){\bf x}_0(t)
$$
That is
$$
\partial_t (e^{-t{\bf A}_0}{\bf y}) = e^{-t{\bf A}_0}{\bf A}_1(t){\bf x}_0(t)
$$
This ODE is solved by 
$$
{\bf y}(t) = \int_0^t e^{(t-\tau){\bf A}_0}{\bf A}_1(\tau){\bf x}_0(\tau){\rm d}\tau
$$
Assume that the system is in steady-state, i.e., ${\bf x}_0(\tau)\equiv {\bf x}_0(\infty)$, then we get 
$$
{{\bf x}_\epsilon(t)} ={\bf x}_0(t) + \epsilon \int_0^t e^{(t-\tau){\bf A}_0} {\bf A}_1(\tau){\rm d}\tau \cdot {\bf x}_0(\infty) + o(\epsilon)
$$
This is just what we need!!! This constitutes a rigorous proof. This equation gives us the first-order approximation of the linear ODE with small time-varying coefficients. Specifically, for a time-varying small preturbation $\epsilon {\bf E}_{k\ell}s(t)$, where $s(t)$ is some known signal, the small-signal system response is 
$$
\Delta{\bf x}_\epsilon(t) = \epsilon [{\bf x}_0(\infty)]_\ell \int_0^t [e^{(t-\tau){\bf A}_0}]_{:,k}s(\tau){\rm d}\tau
$$
where the equivalent transfer function (input scalar to output vector) is given by the $\ell$-th component of ${\bf x}_0(\infty)$ times the $k$-th column of 
$$
\mathcal{L}[e^{t{\bf A}_0}](s) = (s{\bf I} - {\bf A}_0)^{-1}
$$

We may solve this Laplace transform by some numerical techniques, e.g., the minor method.  



## Transient response of the quantum system 

Note that ${\bf x}_0(\infty)$ is the unique stationary point of the ODE. To promote this, we need to express the ODE in a better orthonormal coordinate frame.  

Let
$$
{\bf Q} = [{\bf u}_4, {\bf q}_1, \cdots, {\bf q}_{15}]
$$
be some orthogonal matrix, where ${\bf u}_4$ contains four $1/2$ in the positions corresponding to $\rho_{kk},\,k=1,2,3,4$. Let ${\bf x}(t) = {\bf Q}{\bf y}(t)$ be the variable substitution. With this transform, the A-matrix is converted to ${\bf A}_{\rm new} = {\bf Q}^\mathsf{T}{\bf AQ}$, which is expressed as 
$$
{\bf A}_{\rm new} = \begin{bmatrix}0 & {\bf 0} \\ 
{\bf w} & \tilde{\bf A}
\end{bmatrix}
$$
This indicates that ${\rm d}y_1/{\rm d}t=0$, i.e., $y_1\equiv 1/2$. Further let ${\bf z} = {\bf y}_{2:16}$, we get 
$$
\frac{{\rm d}{\bf z}}{{\rm d}t} = \frac{1}{2}{\bf w} +\tilde{\bf A}{\bf z}
$$
in which the solution is 
$$
{\bf z}(t) = -\frac{1}{2}\tilde{\bf A}^{-1}{\bf w} + e^{t\tilde{\bf A}}\left({\bf z}(0)+\frac{1}{2}\tilde{\bf A}^{-1}{\bf w}\right)
$$
For the perturbation $\tilde{\bf A} + \epsilon \cdot \tilde{\bf A}_1(t)$, the transfer function (input scalar $\epsilon[\tilde{\bf A}_1]_{k\ell}$ to output vector $\Delta{\bf z}$) is given by the $\ell$-th component of $(-1/2)\tilde{\bf A}^{-1}{\bf w}$ , times the $k$-th column of 
$$
\mathcal{L}[e^{t\tilde{\bf A}}](s) = (s{\bf I}-\tilde{\bf A})^{-1}
$$

Now we study how to extract the impulse response of ${\bf H}_{34}$ and ${\bf H}_{43}$ out of the Laplace-transformed results. Generally, these impulse responses constitute a matrix
$$
{\bf T}(s) = [T_{k\ell}(s)]_{4\times 4}
$$


Let
$$
{\bf A}_0 = -i({\bf I}_4\otimes {\bf H}- {\bf H}^T\otimes {\bf I}_4) - \frac{1}{2}({\bf \Gamma}\otimes {\bf I}_4 + {\bf I}_4\otimes {\bf \Gamma}) + \gamma_2 {\bf E}_{1,6}+\gamma_4 {\bf E}_{1, 16} + \gamma_3 {\bf E}_{6, 11}
$$
We wish to determine the locations of ${\bf H}_{34}$ and ${\bf H}_{43}$ in ${\bf A}_0$. They are, respectively with their coefficients, 

$-i$:  (3,4), (7, 8), (11, 12), (15, 16) 

$i$: (13, 9), (14, 10), (15, 11), (16, 12) 



(for ${\bf H}_{43}$)

$-i$: (4,3), (8, 7), (12, 11), (16, 15)

$i$: reverse of (13, 9), (14, 10), (15, 11), (16, 12) 



Let the transfer function from the small variation in $H_{k\ell}(t)$ to $\rho_{21}(t)$ be $T_{k\ell}(s)$. i.e., 
$$
\rho_{21}(t) = \rho_{21, 0}(t) + \sum_{k\ell}\int_0^t \mathcal{L}^{-1}[T_{k\ell}(s)](\tau)H_{k\ell}(t-\tau){\rm d}\tau + o(\epsilon)
$$
Of course, what is more important is $h_{34}(\tau)$ and $h_{43}(\tau)$. Note that
$$
H_{43}(t) = \frac{ \Omega_{\rm LO}+\Omega_{\rm Sig}(I_{\rm BB}(t)+iQ_{\rm BB}(t))}{2}
$$

where $\Omega_{\rm LO} = \mu_{\rm MW}E_{\rm LO}/\hbar$, and $\Omega_{\rm Sig}$ similarly defined as the signal Rabi frequency given the complex-baseband description $I_{\rm BB}=1, Q_{\rm BB}=0$. 

We treat the dimensionless signal part $I_{\rm BB}(t)+iQ_{\rm BB}(t)$ separately from the physical part.  Note that the impulse response from the $k,\ell$-th Hamiltonian term to $\rho_{21}$ is dimensionless (the transfer function $T_{k\ell}$ herein is of dimension $[{\rm s}]$)

Denote the Laplace transform of the small variations in $\rho_{21}(t)$ to be $P_{21}(s)$. We have
$$
P_{21}(s) = \frac{\Omega_{\rm Sig}}{2} \left(T_{34}(s) \left(I_{\rm BB}(s)-iQ_{\rm BB}(s)\right) + T_{43}(s)(I_{\rm BB}(s)+iQ_{\rm BB}(s))\right),
$$
in which we are only interested in the $s$-terms of imaginary coefficients in $P_{21}$. Thus, the transfer function from $I_{\rm BB}(s)$ and ${Q}_{\rm BB}(s)$ to the small variation in $\rho_{21}$ is 
$$
\frac{\mathcal{L}[\rho_{21}](s)}{I_{\rm BB}(s)} = \frac{\Omega_{\rm Sig}}{2} [T_{34}+T_{43}](s)
$$

$$
\frac{\mathcal{L}[\rho_{21}](s)}{Q_{\rm BB}(s)} = i\frac{\Omega_{\rm Sig}}{2}[T_{34}-T_{43}](s)
$$

In the case where all the detunings are zero, we may find that the coefficients of  $T_{34}+T_{43}$ is purely imaginary, while $i(T_{34}-T_{43})$ is real. For the case when detunings are non-zero, these two terms all contribute to the variation in probe transmission. 

Note that the imaginary part of $\rho_{21}$ alters the probe transmission. This means that, up to first-order, the perturbation in $Q_{\rm BB}(t)$ does not change the probe transmission. This is because the amplitude of 
$$
A_{\rm LO} \cos\omega t+\epsilon A_{\rm Sig}\sin\omega t
$$
is well-approximated by 
$$
\sqrt{A_{\rm LO}^2+\epsilon^2{A}_{\rm Sig}^2} \sim A_{\rm LO}(1+O(\epsilon^2))
$$
This well-justifies a superheterodyne structure, where the LO and Sig have small frequency differences. In this case, $Q(t)$ will rotate into $I(t)$ every $1/(4f_{\rm IF})$, thus contributes to the probe transmission. 

For the Sig at $f_{\rm IF}$, the **dimensionless** complex gain of the received symbol $I+iQ$ to the imaginary part of $\rho_{21}$ is given by 
$$
H(i \omega_{\rm IF}) = \frac{\Omega_{\rm Sig}}{2i}\left(T_{34}(i\omega_{\rm IF})+T_{43}(i\omega_{\rm IF})\right)
$$
where $\omega_{\rm IF} = 2\pi f_{\rm IF}$. 

I have correctly done this thing. 



## A new physical quantity: The quantum photoelectric trans-conductance (QPT)

Now let's compute the system "trans-conductance" $g_q(x)$ from the signal E-field $\rm [V/m]$ to the photocurrent change of the PD output per interaction length $\rm [A/m]$.  Note that this quantity do have a dimension of conductance $\rm [S]$. 

The photocurrent is 
$$
\bar{I}_{\rm ph}(t) = \frac{\eta q}{\hbar\omega_p}P_{\rm probe}\exp\left({-2\int_{0}^{L}\alpha(x,t){\rm d}x}\right)
$$
where the attenuation constant of the probe field is expressed as 
$$
\alpha(x,t) = -\frac{k_p N_0\mu_{12}^2}{\epsilon_0\hbar\Omega_p}\Im[\rho_{21}(x,t)]
$$
From a small-perturbation perspective, we derive the end-to-end E-field input -> photocurrent-output response, when excited by an intermediate freq of $\omega$, to be  
$$
\Delta\bar{I}_{\rm ph} =\frac{2k_p N_0\mu_{12}^2}{\epsilon_0\hbar\Omega_p}\bar{I}_{\rm ph,0}\int_0^L \Im[\Delta\rho_{21}(x,i\omega)]{\rm d}x
$$
where 
$$
\Im[\Delta\rho_{21}](x,i\omega) = \frac{\mu_{\rm MW}}{2i\hbar}(T_{34}(i\omega)+T_{43}(i\omega)) \cdot E_{\rm Sig}(x)
$$
If we define the **quantum trans-conductance** to be 
$$
g_q(x, i\omega) := \frac{{\rm d}^2 \bar{I}_{\rm ph}}{{\rm d}E_{\rm Sig}{\rm d}x} = \frac{2k_p N_0\mu_{12}^2}{\epsilon_0\hbar\Omega_p}\bar{I}_{\rm ph,0}\frac{\mu_{\rm MW}}{2i\hbar}(T_{34}(i\omega)+T_{43}(i\omega)),
$$
then we find the frequency response of the AC photocurrent to be  
$$
\Delta\bar{I}_{\rm ph}(i\omega) = \int_0^{L}g_q(x, i\omega)E_{\rm Sig}(x,i\omega){\rm d}x
$$
which simplifies the input-output relation of  the RAQR. Notice that the quantum trans-conductance is usually negative due to EIT-AT. The $E_{\rm sig}$ here is the signal phasor whose reference phase is defined by LO, so it can be extended to the case where $E_{\rm sig}$ is non-uniform across the electric-atomic interaction length. 



Low-frequency response prediction (validation of the theory, compared with simulation ... ==Fig here==)



## Thermal noise analysis

We state that the RAQR is subject to noise that is fundamentally determined by blackbody thermal radiation, instead of anything else such as the noise of photodiodes. The thermal radiation adds directly to the input MW signal, which cannot be distinguished by the RAQR. In the following, we theoretically compute its intensity. 

Just computing the variance of $E_{\rm thermal}(x, i\omega)$ is not enough, since we have the per-Hertz output photocurrent noise caused by the blackbody radiation noise to be  
$$
\begin{aligned}
\mathbb{E}[|\Delta\bar{I}_{\rm ph, noise}(i\omega)|^2] &= \int_0^L{\rm d}x_1 \int_0^L {\rm d}x_2 g_q(x_1, i\omega)g_q^*(x_2, i\omega) \mathbb{E}\left[E_{\rm noise}(x_1, i\omega)E_{\rm noise}^*(x_2, i\omega)\right] \\
&= |g_q(i\omega)|^2 \iint_{[0,L]^2} R_{\rm noise}(x_1-x_2,i\omega){\rm d}x_1{\rm d}x_2\\
&= \frac{|Lg_q(i\omega)|^2}{2L^2}\int_{-L}^{L}{\rm d}v \int_{|u|\leq L-|v|}R_{\rm noise}(u,i\omega){\rm d}u
\end{aligned}
$$
If the noise were not correlated, then the fluctuation of output photocurrent noise is $|Lg_q(i\omega)|^2R_{\rm noise}(0, i\omega)$, which can be directly computed by the blackbody radiation formula. However, the actual noise includes an additional coherence factor 
$$
\zeta(L) = \frac{1}{2L^2R_{\rm noise}(0,i\omega)}\int_{-L}^{L}{\rm d}v \int_{|u|\leq L-|v|}R_{\rm noise}(u,i\omega){\rm d}u,
$$
which satisfies $\zeta(L)<1$.  Clearly, $\zeta$ is a decreasing function of $L$. We can study the asymptotic behavior of $\zeta(L)$ as a function of the quantum aperture $L$. A larger aperture causes a smaller noise variance! 

- small-$L$ regime 
- large-$L$ regime 

Note that the quantity 
$$
\sqrt{\zeta(L)R_{\rm noise}(0, i\omega)}
$$
has dimension ${\rm V m^{-1} Hz^{-1/2}}$, and thus is the fundamental limit of electric field detection by RAQR of ambient radiation temperature $T$. $R_{\rm noise}(0, i\omega)$ is computed to be 
$$
R_{\rm noise}(0, i\omega) = \frac{8\pi}{3}\eta_0 B_\nu(T)
$$
We can compute the fundamental limit for small-aperture RARE to be 
$$
\Delta V \geq 1.74\,{\rm nV\cdot cm^{-1}\cdot Hz^{-1/2}}
$$
which is insurmountable within a thermal ambient temperature of $T=300 {\rm K}$. In comparison, we compute the corresponding dipole sensitivity limit. Assume a planar information-carrying wave. 



This motivates us to compute the spatial correlation function of the blackbody radiation noise per unit bandwidth. Let the spatial correlation function of noise to be $R_{\rm noise}(\Delta x, \omega)$. We expect that this correlation length is about to be $\lambda_c$. 



We choose the Gauss-Legendre quadrature to numerically evaluate this two-dimensional integral. 





[Spatial correlation per unit bandwidth]

The complex amplitude (in V/m) of blackbody radiation noise at frequency $\nu$ per unit bandwidth per unit solid angle is given by 
$$
{\rm d}{\bf E}_{\nu}({\bf x},\hat{\bf r}) = \sqrt{\eta_0 B_\nu(T,\hat{\bf r})} e^{ik_0\hat{\bf r}\cdot{\bf x}}(W_1(\hat{\bf r})\hat{\bf t}_1 + W_2(\hat{\bf r})\hat{t}_2){\rm d}S(\hat{\bf r})
$$
This induces a correlation matrix ${\bf R}_{{\bf E}_\nu}({\bf x},{\bf x}')$ given by 
$$
{\bf R}_{{\bf E}_\nu}({\bf x}, {\bf x'}) = \pi\eta_0B_\nu(T) \cdot  \left[(f_0(\beta)+f_2(\beta)){\bf I}_3+(f_0(\beta)-3f_2(\beta))\hat{\bf r}\hat{\bf r}^\mathsf{T}\right]
$$
Let ${\bf x}={\bf x'}$, we find that, the electric field energy per unit volume per unit bandwidth is given by
$$
\rho_e = \frac{1}{4}\epsilon_0\cdot \pi\eta_0B_\nu\cdot \frac{8}{3}\times 3=2\pi \frac{B_\nu}{c},
$$
which corresponds to half of the total EM energy per unit volume per unit bandwidth
$$
u_\nu = \frac{4\pi}{c}B_\nu
$$
For the typical Rydberg settings, the E-fields are along $\hat{\bf e}_z$, while the interaction length is along $\hat{\bf e}_x$. Thus, we need the $(3,3)$-element of ${\bf R}_{{\bf E}_\nu}$, expressed as a function of $\Delta x$.  



[nV/cm/sqrt(Hz)] We



## Bandwidth Concept

Instantaneous bandwidth? 

bandpass filter 1G->9GHz



Finite-time measurement $[0,T]$ information theory 

RARE 

Projection noise 



## Quantum Sensing (M. Cui)











## Thermal noise and Blackbody radiation 

空间中的热噪声**谱辐射度**（spectral radiance!）为
$$
B_\nu(T) = \frac{2h\nu^3}{c^2}\frac{1}{e^{h\nu/k_{\rm B}T}-1} \approx \frac{2\nu^2}{c^2}k_{\rm B}T
$$
其中$B_\nu(T)$的物理意义为：在环境温度为$T$的环境中，单位频率、单位立体角、单位垂直于传播方向的面元上穿过的热辐射功率。

In the low-frequency regime, we can see that $B_\nu(T)\propto \nu^2$. 



由此可以计算出，对于均匀辐射黑体，温度为$T$，则其表面单位面积、单位频率的热辐射出射功率为$\pi B_\nu(T)$。



考察空间中单位体积的热噪声能量谱密度$u$（${\rm J\cdot m^{-3} \cdot Hz^{-1}}$）。对于每一个来波方向，单位立体角对上述单位体积热噪声能量谱密度$u$的贡献为$B_\nu/c$。对$4\pi$立体角积分即得到结论。也即
$$
u_\nu = \frac{4\pi}{c}B_\nu
$$


考虑$300{\rm K}$的常温环境，微波频率为$10{\rm GHz}$，可以计算得到
$$
\beta h\nu  = 0.0016
$$
因此可以采用低频近似（$\nu \ll k_B T/h$）



考察一根线状的接收机，长度为$L$，电场作用下的原子对的单位长度探测光的传播常数为$\alpha(x, \nu) {\rm [m^{-1}]} = r(x, \nu)\cdot E_\nu(x)$，其中$r(x, \nu) {\rm [V^{-1}]}$为位置$x$处，中频频偏为$\nu$的响应函数。其对应的时域响应为
$$
\alpha(x, t) = 2\Re \left[\int_{0}^\infty r(x,\nu)E_\nu(x){\rm d}\nu \right]
$$


- 热噪声均匀分布于电路的每一个阻抗/传输线中。对于每一只电阻$R$，它具有均方噪声$V_{\rm rms} = \sqrt{4k_{\rm B}TR\Delta f}$。它能产生有效噪声功率$k_{\rm B}T\Delta f$。当电阻$R$发出热噪声时，它本身也在以相同功率吸收热噪声，否则其温度会逐渐下降，违背热力学第二定律。
- 接收天线端口处的热噪声可以直接由黑体辐射公式和天线等效接收面积导出。
- 



## Spatial coherence of thermal radiation

In the microwave regime, we wish to compute the ensemble average 
$$
\langle{\bf E}({\bf x}), {\bf E}{({\bf x'})} \rangle {\rm [V^2/m^2/Hz]}
$$
within some frequency span $\Delta f$ around a center frequency $f_0$, where the E-field vectors ${\bf E}$ are peak values instead of rms values. 

==This problem is resolved in the paper.== 



## Noise of a photodiode 

Assume the arrival of photons follow the Poisson process $\mathcal{PP}(\lambda)$ with intensity $\lambda$. The photon flow intensity  $\lambda$ is given by 
$$
\lambda = \frac{\eta P_{\rm in}}{\hbar\omega_p},
$$
where $\eta=0.8$ is the quantum efficiency, $P_{\rm in}$ is the input laser power, and $\omega_p$ is the angular frequency of the probe light. Let $N(t)$ be the photon-counting process of flow intensity $\lambda$. The distribution of $N(t)$ is 
$$
\Pr[N(t)=n] = \frac{(\lambda t)^n}{n!}e^{-\lambda t}. 
$$
The mean value of $N(t)$ is $\lambda t$. The variance of $N(t)$ is also $\lambda t$. 

Now we want to model $I(t)$ as a Gaussian process with mean $\bar{I}(t)$ and double-sided noise spectral density $n_I/2$. Take the integral of the total noisy signal over some small interval $T$, we get
$$
\bar{Q}(t) = \bar{I}(t)\times T, \quad {\rm var}(Q(t)) = \frac{n_I T}{2}. 
$$
By the counting process, we know that 
$$
\bar{I}\times T=q\lambda T,\quad {\rm var}({\bar{I}\times T})=\frac{n_I T}{2}=q^2\lambda T
$$
This yields $n_I/2=q^2\lambda = q\bar{I}$. Note that the dimension of $n_I$ is $\rm A^2/Hz$. 

The conclusion is that, for any mean-photocurrent $\bar{I}_{\rm ph}$, the current noise have a double-sided PSD of $q\bar{I}$, where $q=1.6\times 10^{-19} {\rm C}$ .  





## Antenna and Microwave Networks 

典型天线的等效接收口面约为
$$
A_e\approx \lambda^2/(4\pi)
$$

This conclusion is drawn by first computing the effective aperture of a short dipole antenna (with the concept of effective length & radiative resistance), and then extend this to all kinds of antennas with the help of the reciprocal theorem. 

Friis transmission formula for a pair of antennas 
$$
P_{\rm R} = \frac{\lambda^2}{4\pi} \cdot \frac{G_T G_R}{4\pi r^2} \cdot P_{\rm T}
$$
where $G_T, G_R$ are in $\rm dBi$. 

 

有关天线知识的教科书：https://phys.libretexts.org/Bookshelves/Electricity_and_Magnetism/Electromagnetics_and_Applications_(Staelin)/10%3A_Antennas_and_Radiation/10.03%3A_Antenna_gain_effective_area_and_circuit_properties

复数坡印廷定理
$$
\nabla\cdot \tilde{\bf S} = -\frac{1}{2}\left({\bf J}_f^*\cdot{\bf E} + j\omega({\bf B}\cdot{\bf H}^*-{\bf E}\cdot{\bf D}^*)\right)
$$
坡印廷矢量定义为
$$
\tilde{\bf S} = \frac{1}{2}{\bf E}\times {\bf H}^*
$$
计算天线端口阻抗的公式，可以由此复坡印廷定理导出。



**Switch to engineering convention** 

Evaluation of the Waveguide Voltage and Waveguide Current, from source to load: z to 0 
$$
{\bf E}(x,y,z) = {\bf E}(x,y)e^{j\beta z}e^{j\omega t}
$$

$$
\begin{aligned}
{\bf E}(x,y) &= {\bf e}(x,y) V \\ 
{\bf H}(x,y) &= {\bf h}(x,y) I \\ 
\end{aligned}
$$

where ${\bf e},{\bf h}$ has unit ${\rm [m^{-1}]}$, and satisfies 
$$
\int \Re[{\bf e}\times {\bf h}^*]{\rm d}S=1
$$
In this way, we find that the time-averaged power of a travelling wave in the waveguide equals 
$$
P=\frac{1}{2}\Re[VI^*]
$$
Now we need to find some canonical definition of $V$ such that $V$ equals the low-frequency canonical definition of $V$ (in voltage). 



Let's take the Physicist's convention now ($\partial_t \to -i\omega$). Let $\bf P$ be the complex polarization vector, $\bf E$ be the complex electric field vector. 
$$
{\bf P} = \epsilon_0 \chi_e {\bf E}
$$
 The polarization current is given by 
$$
{\bf J}_p = -i\omega {\bf P}
$$
The power dissipation (per volume) caused by polarization phase lag is given by 
$$
p = \frac{{\rm d}P}{{\rm d}V} = \frac{1}{2}\Re\left[{\bf J}_p\cdot{\bf E}^*\right] = \frac{\omega\epsilon_0|{\bf E}|^2}{2} \Im[\chi_e]
$$


## Atomic Spectroscopy

- 非线性光学 https://byucamacholab.github.io/nonlinear-optics/pages/22.%20Electromagnetically%20Induced%20Transparency.html



## Equivalent baseband models (EBM)

Principles and notations in the baseband model part. 

- Baseband signals are always digital with no physical dimension.  
- Complex envelope (analytic signal) representation of some real-valued physical signal, e.g., RF voltage, low-freq voltage, current, etc. To apply complex envelope representation, a reference frequency is always specified (can be zero). Complex envelopes are denoted by superscript **ce**.  
- Spectrum of real-valued signal is always single-sided. Fourier spectrum is denoted by its variable $i\omega$, but always measured in per Hz, not per rad/s. Power spectrum follows the same convention. 
- Spectrum of complex envelopes and baseband signals are always double-sided.  Power spectrum follows the same convention. 

Definition of analytic signals (complex envelope)

For a real-valued signal $x(t)$, the complex envelope is defined as 
$$
x^{\rm ce}(t) = 2\int_0^\infty \mathcal{F}[x](2\pi f)e^{i2\pi f t}{\rm d} f
$$
Specifically, for example, $x(t) = \cos(\omega_0 t+\varphi_0)$, the analytic signal is $x^{\rm ce}(t) = e^{i\omega t}e^{i\varphi_0}$. Note that the function $t\to x(t)$ is analytic in the upper complex plane, and that $\Re[x^{\rm ce}(t)] = x(t), \forall t\in\mathbb{R}$. 

 



Let the transmitted signal complex envelope representation be 
$$
x_{\rm Tx}(t) = \sqrt{P_{\rm T}} \sum_{n=-\infty}^\infty x(n) {\rm sinc}(Wt-n)
$$
where $x(n)$ is some complex sequence with unit power. The spectral representation is 
$$
\mathcal{F}[{\rm sinc}(Wt)](f) = \frac{1}{W}{\rm I}_{[-W/2, W/2]}(f)
$$
where the Fourier convention is in $(t,f)$. 

After up-coverting to RF, the PSD is 
$$
P_{\rm Tx, RF}(f) = \frac{1}{2W}\left({\rm I}_{[-W/2, W/2]}(f-f_{\rm LO})+{\rm I}_{[-W/2, W/2]}(f+f_{\rm LO})  \right)
$$


With the factor $\sqrt{2}$, the complex envelope energy == the actual signal energy within any band $0<[f_1, f_2]$. 

Another convention is such that no $\sqrt{2}$ factor is introduced. In this case, we have 
$$
x_{\rm RF}(t) = \Re[x_{\rm Tx}^{\rm ce}(t)e^{i2\pi f_{\rm LO}t}]
$$
In this case, the actual  RF PSD will be half of that observed by the complex envelope. However, the peak value of the complex envelope is aligned to that of RF.  In the following, we stick to this **peak-preserving** convention. In this way, the double-sided complex envelope PSD $P_x(f)$ and the single-sided RF PSD $S_{\rm RF}(f)$ is given by 
$$
S_{\rm RF}(f) = \frac{1}{2} P_x(f-f_{\rm LO})
$$
 where $S$ denotes single-sided PSD, and $P_x$ denotes double-sided PSD throughout this paper. 



To ensure that the actual transmitted signal has power $P_{\rm T}$, the complex envelope representation of the Tx signal is **updated** to be 
$$
x_{\rm Tx}(t) = \sqrt{2P_{\rm T}} \sum_{n=-\infty}^\infty x(n) {\rm sinc}(Wt-n)
$$
where the transmit baseband signal is $x_{\rm BB}(t)=\sum_n x(n){\rm sinc}(Wt-n)$. 

After transmitted through the channel, the complex envelope representation of the E-field signal $E_{\rm sig}^{\rm ce}(t) = E_{\rm sig, 0}(I(t)+iQ(t))$becomes 
$$
\begin{aligned}
E_{\rm sig}^{\rm ce}(t) &= e^{i2\pi f_{\rm IF}t}\sqrt{\eta_0}\cdot\sqrt{\frac{4\pi}{\lambda^2}}\left(\frac{\lambda}{4\pi r}e^{-ikr}\right)\cdot \sqrt{2P_{\rm T}} x_{\rm BB}(t) \\
&= e^{i2\pi f_{\rm IF}t} \sqrt{\frac{8\pi\eta_0P_{\rm T}}{\lambda^2}} \cdot H \cdot    x_{\rm BB}(t) \quad{\rm [V/m]}
\end{aligned}
$$
After passing through the RAQR described by $g_q = g_q(i2\pi f_{\rm IF})$, the output photocurrent signal (one-stream, real signal) is represented by the $f_{\rm ref}=0$-complex envelope as  
$$
\Delta I_{\rm sig}(t) = \Re[\Delta I_{\rm sig}^{\rm ce}(t)]
$$
 where the complex envelope of $\Delta I_{\rm sig}(t)$ with reference frequency $f_{\rm IF}$ is given by 
$$
\Delta I_{\rm sig}^{\rm ce}(t) =  L g_q  E_{\rm sig}^{\rm ce}(t)
$$
 $I_{\rm sig}(t)$ is then fed into a transimpedance amplifier of transimpedance $R_{\rm T}K_c$. The output voltage signal complex envelope is 
$$
V_{\rm sig}^{\rm ce}(t) = R_{\rm T}K_c \Delta I_{\rm sig}^{\rm ce}(t)
$$
 A down-converter with orthogonal IF mixers is then applied. Assume the down-converter has an in-phase LO of $\cos(2\pi f_{\rm IF}t)$ and a quadrature LO of $-\sin(2\pi f_{\rm IF}t)$. The output of these two mixers is represented by a complex baseband signal $y_{\rm BB}(t)$. Then, 
$$
y_{\rm BB}(t) = \frac{1}{2V_{\rm ref}}V_{\rm sig}^{\rm ce}(t)e^{-i2\pi f_{\rm IF}t}
$$
where $V_{\rm ref}$ is the reference voltage of the ADC. 

The baseband representation transfer relationship is given by 
$$
y_{\rm BB}(t) = \sqrt{\frac{P_{\rm T}}{P_{\rm qref}}}H x_{\rm BB}(t) + w_{\rm BB}(t)
$$
where the quantum reference power $P_{\rm qref}$ is given by 
$$
\frac{1}{\sqrt{P_{\rm qref}}} = \frac{1}{2V_{\rm ref}} R_{\rm T}K_c L g_q \sqrt{\frac{8\pi \eta_0}{\lambda^2}}
$$
The next step is to analyze the complex-valued noise process $w_{\rm BB}(t)$. We consider three noise sources, i.e., BBR, photon shot noise, and thermal noise. 

Thermal noise described by $V_{\rm n, TIA}$ and $I_{\rm n, TIA}$. Assume them to be single-sided. We know that frequency converter of $f_{\rm IF}$ has a magnitude attenuation factor of $1/2$. , i.e., a power attenuation of $1/4$. Since the noises in two sidebands will enter the receiver, we derive the equiv. noise rms value per Hz at the output of IF mixer to be 
$$
V_{\rm nI,TIA} = V_{\rm n, TIA}\cdot \frac{R_{\rm T}}{Z_{\rm in}+R_s}/\sqrt{2}.
$$
The Q-branch is the same, but the I-branch noise and Q-branch noise is not uncorrelated if given the I-branch result. 

From the above analysis, we find that the total complex power at baseband $I_r,Q_r$ is given by just the original number $V_{\rm n, TIA}$ that enters the mixer. Generally, if we know the pre-mixer single-sided voltage noise as some number, then the complex noise power at the output of the IF IQ mixer is just the same value per Hz. Generally, the IF-IQ mixer does not degrade the link SNR. 

For the BBR noise, it is introduced in the very beginning in $E_{\rm sig}^{\rm ce}$, and in a double-sided manner. Let the single-frequency point BBR noise phasor be $E_{\rm n, bbr}\,{\rm [V/m/\sqrt{Hz}]}$. The induced complex noise std at Rx baseband is 
$$
\sigma_{\rm w, bbr} = \frac{1}{V_{\rm ref}}(R_{\rm T}K_c)\cdot{Lg_q}{\sqrt{\zeta(\ell)}} \cdot \sqrt{2} E_{\rm n,bbr},
$$
where $\sqrt{2}$ comes from the mirror freq noise.  

For the photon shot noise, it is introduced in $\Delta I_{\rm sig}^{\rm ce}$. as a per-Hz complex phasor.  The shot noise double-sided PSD is $q_e \bar{I}_{\rm ph}$, which means a noise phasor of $\sqrt{2q_e \bar{I}_{\rm ph}}\quad {\rm [A/\sqrt{Hz}]}$.  This noise phasor passes through the TIA and IF mixer, creating a complex noise std of 
$$
\sigma_{\rm w, shot} = \frac{1}{V_{\rm ref}}(R_{\rm T}K_c)\sqrt{2q_e\bar{I}_{\rm ph}}
$$


An equivalent baseband sample representation (with sampling interval $1/W$ ) is 
$$
y(n) = \sqrt{\frac{P_{\rm T}}{P_{\rm qref}}}hx(n) + w(n),
$$
where the variance of $w(n)$ is $Wn_w^2$. Furthermore, we can extend this model to a point-to-point MIMO model, which is expressed by 
$$
{\bf y} = \sqrt{P_{\rm T}/P_{\rm qref}} {\bf H}{\bf x} + {\bf w}
$$







## Algorithm Speedup 

Code optimization is also important. 

The slowest part is the evaluation of quantum transfer functions. 

The parameter settings will be carefully optimized. 



## Noise factor at each stage



Let $P_{\rm n,L}$ be the laser intensity noise in $\rm [W/\sqrt{Hz}]$. The calculation formula is 
$$
P_{\rm n,L} = (P_0^2 \times (10^{-14})\times {\rm BW})^{1/2}
$$
The double-sided noise current PSD $\rm [A^2/Hz]$ caused by the laser intensity noise in the output PD photocurrent is 
$$
P_{\Delta I_n}(\omega) = (\eta \frac{q_e}{\hbar\omega_p}P_0)^2 \times (10^{-14})/2
$$


For the laser's thermal noise, the DS-PSD is given by $k_{\rm B}T/2$. The equivalent noise current DS-PSD is 
$$
P_{\rm atom}(\omega) = (\frac{\eta q_e}{\hbar\omega_p})\cdot k_{\rm B}T/2
$$
I do not know how to compute the current PSD induced by this thermal noise. 



Mismatched noise factor is larger. 
$$
F_m = 1+\frac{F-1}{1-|\Gamma|^2}
$$
where $F$ is the matched noise factor (smallest). 



Now we wish to find the consistent definition of noise factors in the case where each amplification stage is not perfectly matched. 

We always define the SNR to be the input voltage spectral density ratio (sig/noise) divided by the output voltage spectral density ratio (sig/noise). This can be achieved by invalidating the unrelated voltage/current sources. During this analysis, the signal source can always be set to 1. 

This definition is consistent with that based on current PSD. 



## How to add noise in simulation? 

- For a $\Delta t$-sampled real signal with noise SS-PSD $n_0$, the added noise variance is $\sigma_n^2 = n_0/(2\Delta t)$. 

- For a $\Delta t$-sampled complex signal with noise DS-PSD $n_0/2$, the added noise complex variance is $\sigma_n^2 = (n_0/2)/\Delta t$. 
- For a $\Delta t$-sampled complex analytic signal with original real-valued SS-PSD $n_0$, the added complex noise variance is $\sigma_n^2 = n_0/\Delta t$. 

When adding noise to $E_{\rm sig}(t)$, we first need to identify what $E_{\rm sig}(t)$ represents. For a time-varying field $E(t)$, let $E_a(t)$ be its analytic representation. Then 
$$
E_{\rm sig}(t) = E_a(t) e^{-i2\pi f_{\rm RF} t}
$$
Although $E_a(t)$ is a single-sided signal, $E_{\rm sig}(t)$ is possibly double-sided. Assume we add noise independently to each sample $E_a(n\Delta t)$. Then the noise-adding law of $E_{\rm sig}$ is the same as the noise adding law of $E_a$. 



The average power-computing formula for $E_a$ and $E(t)$ is different: 
$$
\bar{P} = \overline{\frac{1}{T}\int_{-T/2}^{T/2}E^2(t){\rm d}t}
$$

$$
\bar{P} = \overline{\frac{1}{2T}\int_{-T/2}^{T/2}|E_a(t)|^2 {\rm d}t}
$$

Note that $|E_a| = |E_{\rm sig}|$. Generally, the variance of $E_a(t)$ is twice that of $E(t)$. 



From the above discussion, we can see that for a real-valued bandpass signal $X$ of noise SS-PSD $n_0$, the noises added to $X_a(n\Delta t)$ is of complex variance  $n_0/\Delta t$. Furthermore, the noises added to $X_{\rm sig}(t) = X_a(t)e^{-i2\pi f_c t}$ is of the same complex variance $n_0/\Delta t$. 



## Quantum error correction (QEC) 









## Paper writing (Rydberg quantum receiver)

标题：

(1) A transient signal and noise analysis framework for Rydberg atomic receivers with application to OFDM communication systems 

(2) Electromagnetic information theory-enabled transient analysis framework for Rydberg atomic receivers. 

(3) A wideband model for Rydberg atomic receivers 



- 如何写出4能级EIT系统的哈密顿量？参考Nature Physics. Now I fully understand this thing. 
- 和电磁信息论的关联：(1) 噪声 (2) 互信息



如何引入电磁信息论的概念？



Figures

- 概念图1：量子接收机链路与各类噪声源
- 概念图2：量子跨导在分析量子接收机的IQ响应时的应用
- 仿真图1：横轴是经典接收机接收功率（dBm），纵轴是经典vs量子接收机接收SNR（dB）
- ​