## Paper Information 

This simulation code package is mainly used to reproduce the results of the following paper [1]:

[1] J. Zhu and L. Dai, "General signal model and capacity limit for Rydberg quantum information system," *IEEE Trans. Wireless Commun.*, early access, Dec. 2025.  

--------

**If you use this simulation code package in any way, please cite the original paper [1] above.** 

The author in charge of this simulation code package is: **Jieao Zhu** (email:  [zja21@mails.tsinghua.edu.cn]()  ; johnzja@qq.com).

Reference: We highly respect reproducible research, so we try to provide the simulation codes for our published papers (more information can be found at: 
http://oa.ee.tsinghua.edu.cn/dailinglong/publications/publications.html). 

Please note that the MATLAB R2025a is used for this simulation code package, and there may be some incompatibility problems among different MATLAB versions.  

Copyright reserved by the Broadband Communications and Signal Processing Laboratory (led by Dr. Linglong Dai), Department of Electronic Engineering, Tsinghua University, Beijing 100084, China.  

-------

Abstract of the paper: 

**Abstract**—Rydberg atomic receivers represent a transformative approach to achieving high-sensitivity, broadband, and miniaturized radio frequency (RF) reception. However, existing static signal models for Rydberg atomic receivers rely on the steady-state assumption of atomic quantum states, which cannot fully describe the signal reception process of dynamic signals. To fill in this gap, in this paper, we present a general model to compute the dynamic signal response of Rydberg atomic receivers in closed form. Specifically, by applying small-signal perturbation techniques to the quantum master equation, we derive closed-form Laplace domain transfer functions that characterize the receiver’s dynamic responses to time-varying signal fields. To gain more insights into the quantum-based RF-photocurrent conversion process, we further introduce the concept of quantum transconductance that describes the quantum system as an equivalent classical system. By applying quantum transconductance, we quantify the influence of in-band blackbody radiation (BBR) noise on the atomic receiver sensitivity. Extensive simulations for Rydberg atomic receivers validate the proposed signal model, and demonstrate the possibility of quantum receivers to outperform classical electronic receivers through the improvement of quantum transconductance.

--------



## MATLAB Code Usage Description 

| MATLAB script                   | Description                              | Paper figure       |
| ------------------------------- | ---------------------------------------- | ------------------ |
| ./sim_ptResp_transit.m          | Draws the probe transmission (pt) as a function of $E_{\rm LO}$ , taking into consideration the Doppler broadening and the transit broadening effects. |                    |
| ./sim_gqFreqResp.m              | Draws the quantum transconductance $g_q$ as a function of $E_{\rm LO}$ and $f_{\rm IF}$. | Fig. 9             |
| ./study_DCtransfer.m            | Draws the probe response as a function of $E_{\rm LO}$. | Fig. 2             |
| ./sim_noise.m                   | Draws the quantum transconductance and output noise PSD as a function of $f_{\rm IF}$ ; Draws the noise factors as a function of the photodiode bias resistor $R_{s}$. | Fig. 5 and Fig. 7  |
| ./wfsims/sim_singleCarrier.m    | Performs single-carrier transmission test for Rydberg atomic receivers. | Fig. 6 and Fig. 11 |
| ./sim_QuantumTransConductance.m | Draws the zero-pole plot and frequency response of the quantum transconductance $g_q(s)$ at atomic temperature $T=0\,{\rm K}$. | Fig. 10            |
| ./sim_RydbergMIMO.m             | Performs Rydberg-MIMO capacity simulation, compared with conventional RF receivers with antenna mutual coupling. | Fig. 12            |

----

Enjoy the reproducible research! 

