clear; close all; clc; 

RAQR_config.d   = 2e-2;                 % 2cm
RAQR_config.N0  = (4.89e10)*(1e6);      % number of atoms per m^3 

RAQR_config.Delta_p = 2*pi*0e3; 
RAQR_config.Delta_c = 2*pi*0e6;         % Coupling laser detuning
RAQR_config.Delta_l = 2*pi*0e3; 

RAQR_config.gamma   = 0;
RAQR_config.gamma_2 = 2*pi*5.2e6; 
RAQR_config.gamma_3 = 2*pi*3.9e3; 
RAQR_config.gamma_4 = 2*pi*1.7e3; 
RAQR_config.gamma_c = 0; 

% RAQR_config.Omega_c     = 2*pi*0.97e6;               % coupling beam 17.0mW  @ 510nm
RAQR_config.Omega_c     = 2*pi*10e6;               % coupling/control beam 17.0mW  @ 510nm, if this is stronger, you will get a better EIT spectrum 
% RAQR_config.Omega_p     = 2*pi*5.7e6;               % probe    beam 29.8uW  @ 852nm
RAQR_config.Omega_p     = 2*pi*5.7e6;

RAQR_config.lambda_c    = 510e-9; 
RAQR_config.lambda_p    = 852e-9; 

%% Study the parameters
% Omega_c, Omega_p, E_RF (LO peak strength), Delta_p, Delta_c 
% 

fOmega_cArr = (-20:0.2:20)*1e6+0.01; 
fOmega_pArr = (-40:0.2:40)*1e6-0.01; 

Nc = length(fOmega_cArr); 
Np = length(fOmega_pArr); 
[fOmega_cMat, fOmega_pMat] = meshgrid(fOmega_cArr, fOmega_pArr);  
pResponseMat = zeros(size(fOmega_cMat)); 

E_RF = 0.3*sqrt(2); 
parfor ic = 1:Nc
    for ip = 1:Np
        temp_RAQR_config                        = RAQR_config; 
        temp_RAQR_config.Omega_c                = 2*pi*fOmega_cMat(ip, ic); 
        temp_RAQR_config.Omega_p                = 2*pi*fOmega_pMat(ip, ic); 
        [rho_arr_steady, probeResponseSteady]   = getSteadySolution(temp_RAQR_config, E_RF);
        pResponseMat(ip, ic)                    = db2pow(probeResponseSteady); 
    end
end

% 
RAQR_config.Omega_c = 2*pi*0.97e6; 
RAQR_config.Omega_p = 2*pi*5.7e6; 
fDelta_cArr         = (-20:0.2:20)*1e6+0.01; 
fDelta_pArr         = (-40:0.2:40)*1e6-0.01; 

Nc = length(fDelta_cArr); 
Np = length(fDelta_pArr); 
[fDelta_cMat, fDelta_pMat]  = meshgrid(fDelta_cArr, fDelta_pArr);  
pResponseMatDelta           = zeros(size(fDelta_cMat)); 

E_RF = 0.3*sqrt(2); 
parfor ic = 1:Nc
    for ip = 1:Np
        temp_RAQR_config                        = RAQR_config; 
        temp_RAQR_config.Delta_c                = 2*pi*fDelta_cMat(ip, ic); 
        temp_RAQR_config.Delta_p                = 2*pi*fDelta_pMat(ip, ic); 
        [rho_arr_steady, probeResponseSteady]   = getSteadySolution(temp_RAQR_config, E_RF);
        pResponseMatDelta(ip, ic)               = db2pow(probeResponseSteady); 
    end
end

%% Visualization 
close all; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    12);
set(0,'DefaultAxesFontSize',    14);
set(0,'DefaultLineLineWidth',   1.5);
set(0,'defaultfigurecolor',     'w');

fig1 = figure(1); 
surf(fOmega_cMat/(1e6), fOmega_pMat/(1e6), pResponseMat); 
view(0, 90); shading interp; 
colorbar; 
xlabel('\Omega_c/(2\pi) (MHz)'); 
ylabel('\Omega_p/(2\pi) (MHz)'); 

fig2 = figure(2); 
surf(fDelta_cMat/(1e6), fDelta_pMat/(1e6), pResponseMatDelta); view(0, 90); 
shading interp; 
colorbar; 
xlabel('\Delta_c/(2\pi) (MHz)'); 
ylabel('\Delta_p/(2\pi) (MHz)'); 


