% ================================================= % 
% 
%  Doppler analytical response 
%  Author: Jieao Zhu
%  Date:   15 Sept 2025 
% ================================================= % 

clear all; close all; clc; 

RAQR_config = configureRAQR(); 

% Re-configure some important parameters 
RAQR_config.Omega_c     = 2*pi*5e6;             % coupling beam 17.0mW  @ 510nm
RAQR_config.Omega_p     = 2*pi*2e6;             % probe    beam 29.8uW  @ 852nm


RAQR_config.A_LO    = 0.2; 
eps                 = 1e-6; 



%% Use new method to evaluate the Doppler ensemble average 

Temperature     = 300; 
freq_arr        = logspace(2, 6.5, 200); 

% info_struct = getSteadySolutionWithDoppler(RAQR_config, RAQR_config.A_LO, Temperature); 
tic; 
gq_struct_numerical     = getNumericalFreqResponse(RAQR_config, Temperature, freq_arr); 
fprintf('Numerical: Time elapsed = %.3f s\n', toc);  

tic; 
gq_struct_analytical    = getAnalyticalFreqResponse(RAQR_config, Temperature, freq_arr); 
fprintf('Analytical: Time elapsed = %.3f s\n', toc); 


%% 
close all; 
set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    12);
set(0,'DefaultAxesFontSize',    14);
set(0,'DefaultLineLineWidth',   1.5);
set(0,'defaultfigurecolor',     'w');
savefigs = false; 

fig1 = figure(1); 
plot(freq_arr, mag2db(1e3*abs(gq_struct_numerical.gq)), 'Marker', '+', 'Color', 'magenta'); hold on; 
plot(freq_arr, mag2db(1e3*abs(gq_struct_analytical.gq)), 'LineStyle', '--', 'Color', 'k');  
set(gca, 'xscale', 'log'); 
grid on; 
xlabel('Freq (Hz)'); 
ylabel('g_q (dBmS)'); 
legend({'Numerical', 'Analytical'}, 'Location', 'best'); 

if savefigs
    exportgraphics(fig1, "./results/jpgs/T_NumericalAnalytical_gq.jpg"); 
    fprintf('Files saved.\n'); 
end
