clear all; clc; close all; 

% Fsym        = 1; 
% Fs          = 10; 
beta        = 0.25; 
delay       = 4; 

Nrcl    = 20;       % Length of Raised cosine filter (in #symbols) 
L       = 20;       % IF freq / Sym rate, down-sampling rate 

b       = rcosdesign(beta, Nrcl, L, "normal");     % ensure that sum(b.^2) == 1. 


Nrc     = length(b); 

% Amplitude compensation 
% b = b / sqrt(Fs/Fsym); 

figure(1);
impz(b, 1);
figure(2); 
freqz(b, 1); 
