clear; close all; clc; 

Nd = 1501; 

[x_knots, x_probs] = getNormalQuadrature(Nd, "DenseCenter"); 
[x_knots_2, x_probs_2] = getNormalQuadrature(Nd); 


z = -5i; 

% Method 1: using numerical approximation 

result_1 = sum(1./(1+z*x_knots).*x_probs);
result_2 = sum(1./(1+z*x_knots_2).*x_probs_2); 

% Method 2: using Mathematica's formula 
result_3 = (-1/z)*(1/sqrt(2*pi))*exp(-1/2/z^2)*(pi*erfi(-1/sqrt(2)/z) - log(-1/z) - log(z)); 


