function [SNR_dB]=commParams(d_UE)
N_BS = 256;

n0 = db2pow(-174 - 30);         % 174dBm/Hz thermal noise.
BW = 1e9;                      % system bandwidth. 
N_OFDM = 256;                  % OFDM FFT size. 
BW_singleCarrier = BW/N_OFDM;   
noiseFactor_dB = 10;            % due to imperfections in LNA, mixers, and ADCs. 


Pt = db2pow(50 - 30);           % BS total transmit power (dBm).

fc = 60e9;
c = physconst("lightspeed");
lambda = c/fc;



pathLossFactor = 1;

PL = mag2db(lambda/(4*pi)/d_UE^(pathLossFactor));
GTx_dB = 3;                             % Transmit antenna gain. 
GRx_dB = 0;                             % Receive antenna gain. 

%channelGain_dB = GTx_dB + mag2db(N_BS) + GRx_dB + PL;  % Antenna gains + Array gain - Path loss. 
channelGain_dB = GTx_dB + PL;

recvPower_dB = pow2db(Pt/N_OFDM) + channelGain_dB; 
%noisePower_dB = pow2db(n0*BW_singleCarrier) + noiseFactor_dB;
noisePower_dB = -110;

SNR_dB = recvPower_dB - noisePower_dB; 
end




