function [v] = generate_widebeam(Nt,index)
    nn = (0:1:Nt-1)';
    codeword = -1+1/Nt:2/Nt:1-1/Nt;
    codebook = exp(1j*pi*nn*codeword)/sqrt(Nt);
    index_length = length(index);
    v = zeros(Nt,1);
    for idx = 1:index_length
        v = v + exp(1j*pi*index(idx)*(-1+1/Nt)) * codebook(:,index(idx));  %生成理想波束
    end
    v = v/norm(v);
end