function [v] = generate_widebeam2(Nt,index)
    index_length = length(index);
    K = 2*Nt;     %扫描角度划分
    g_Omega = zeros(K,1);           %预期波形形状幅度
    for idx = 1:index_length
        g_Omega(idx*2-1,1)=1;
        g_Omega(idx*2,1)=1;
    end
    Omega_k = (-1+(2*[1:K]-1)/K)';  %扫描角度范围
    A = zeros(Nt,K);
    for k = 1:K
        A(:,k) =  exp(1j*pi*Omega_k(k).*([1:Nt]'-1));
    end


    theta = exp(1j*2*pi.*rand(K,1));

    U = diag(g_Omega)*(A'*A)*diag(g_Omega);   
    U = (U+U')/2;

    theta = MMAlgorithm(-U, zeros(K,1), theta, 1000, 0.00001);

    g = diag(g_Omega)*theta;
    v = 1/K*A*g;
    v = v/norm(v);
end