function  [w_hierarchy_far] = hierarchy_codebook(Nt)
    l=log2(Nt)-1;
    w_hierarchy_far=zeros(l,2,Nt);
    index=zeros(2*l,Nt/2);
    temp_codebook= zeros(l,Nt);
    for i=1:(Nt/2)
        temp_codebook(:,2*i-1)=(dec2bin(i-1, l) - '0');
        temp_codebook(:,2*i)=temp_codebook(:,2*i-1);
    end
    for i=1:l
        index(2*i-1,:)=find(temp_codebook(i,:)==0);
        index(2*i,:)=find(temp_codebook(i,:)==1);
    end
    for i=1:l
        w_hierarchy_far(i,1,:)=generate_widebeam(Nt,index(2*i-1,:));
        w_hierarchy_far(i,2,:)=generate_widebeam(Nt,index(2*i,:));
    end
end