function [w_hierarchy_conv] = hierarchy_conv_codebook1(Nt,conv_encoder_conf)
    N=log2(Nt)-1;
    conv_encoder_trailing=false;
    w_hierarchy_conv=zeros(2*N,2,Nt);
    index=zeros(4*N,Nt/2);
    Codebook=zeros(2*N,Nt);
    for i=1:Nt/2
        Codebook(:,2*i-1)= conv_encode((dec2bin(i-1, N) - '0'), conv_encoder_conf)';
        Codebook(:,2*i)= Codebook(:,2*i-1);
    end
    for i=1:(2*N)
        index(2*i-1,:)=find(Codebook(i,:)==0);
        index(2*i,:)=find(Codebook(i,:)==1);
    end
    for i=1:(2*N)
        w_hierarchy_conv(i,1,:)=generate_widebeam(Nt,index(2*i-1,:));
        w_hierarchy_conv(i,2,:)=generate_widebeam(Nt,index(2*i,:));
    end
end