clear all;clc;
%参数设置
Nt = 1024;
f = 60e9;
c = 3e8;
K = 1; % 用户数量
L = 1; % 每个用户的路径数（先考虑LOS径）
lambda = c/f;
d = lambda / 2;
N_iter = 1000;
theta_min = - pi / 2;
theta_max = pi / 2;

%遍历算法BS、UE端码本
[w_far_BS] = exhaustive_codebook(Nt);
%BS端二分法分层码本
[w_hierarchy_tra] = hierarchy_binary_codebook(Nt);
%BS端conv code分层码本
setup_encoder;
[Codebook] = hierarchy_conv_codebook(Nt,conv_encoder_conf);
%% Start Simulation
t0 = clock;
SNR_dB_list=[-10:2:10];
SNR_list = 10.^(SNR_dB_list/10.);
SNR_len = length(SNR_dB_list);

r_gau = zeros(length(SNR_list),1);
r_softconv_hierarchy = zeros(length(SNR_list),1);

for idx = 1:SNR_len
    SNR_dB = SNR_dB_list(idx);
    SNR = SNR_list(idx);
    fprintf('SNR_dB = %.4f[%d/%d] | run %.4f s\n', SNR_dB,  idx, SNR_len,  etime(clock, t0)); 
    for i_iter = 1:N_iter  
        for k = 1:K
            theta_DoA(1,k) = unidrnd(Nt);
            [H(:,k),h_BS(:,k)] = generate_channel(Nt,theta_DoA(1,k),d,lambda);
        end 
        %理论上界
        for k = 1:K
            [array_gain_opt(1,k),id_BS_opt(1,k)] = training_exhaustive(w_far_BS,H(:,k),100000,Nt);
        end
        %卷积码分层训练-软译码
        for k = 1:K
            [array_gain_softconv(1,k),id_BS_softconv(1,k)] = training_hierarchy_softconv(Codebook,H(:,k),SNR,Nt,conv_encoder_conf);
            if id_BS_softconv(1,k)==id_BS_opt(1,k)
                r_softconv_hierarchy(idx)=r_softconv_hierarchy(idx)+1;
            end
        end
        %高斯分布
        [array_gain_Gaussian,id_BS_Gaussian]= training_hierarchy_gau(Codebook,H(:,k),SNR,Nt,conv_encoder_conf);
        for k = 1:K
            if id_BS_Gaussian(1,k)==id_BS_opt(1,k)
                r_gau(idx)=r_gau(idx)+1;
            end
        end
    end
end
r_gau = r_gau/K/N_iter;
r_softconv_hierarchy=r_softconv_hierarchy/K/N_iter;
%%  plot figure

C = linspecer(2);
maker_num = 25;
figure; hold on; box on; grid on;
p1 = plot(SNR_dB_list, r_softconv_hierarchy, '-d', 'color', C(1, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p2 = plot(SNR_dB_list, r_gau, '-o','color', C(2, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
xlabel('SNR (dB)', 'interpreter', 'latex', 'fontsize', 12)
ylabel('Success Rate', 'interpreter', 'latex', 'fontsize', 12)
legend([p1,p2],{'Proposed decoder','Traditional Gaussian decoder'}, 'interpreter', 'latex', 'fontsize', 12);
