clear all;clc;
%参数设置
Nt = 256;
f = 60e9;
c = 3e8;
K = 1; % 用户数量
L = 1; % 每个用户的路径数（先考虑LOS径）
lambda = c/f;
d = lambda / 2;
N_iter = 1000;
theta_min = - pi / 2;
theta_max = pi / 2;

%遍历算法BS端码本
[w_far_BS] = exhaustive_codebook(Nt);
%BS端重复码码本
[w_hierarchy_far] = hierarchy_codebook(Nt);
%BS端二分法分层码本
[w_hierarchy_tra] = hierarchy_binary_codebook(Nt);
%BS端conv code分层码本(adaptive)
setup_encoder;
[Codebook] = hierarchy_conv_codebook(Nt,conv_encoder_conf);


%% Start Simulation

t0 = clock;
dis_list=[40:20:200];
for i =1:length(dis_list)
    SNR_dB_list(i)=commParams(dis_list(i));
end
SNR_list = 10.^(SNR_dB_list/10.);
SNR_len = length(SNR_dB_list);

r_tra0 = zeros(length(SNR_list),1);
r_far_exhaustive0 = zeros(length(SNR_list),1);
r_softconv_hierarchy0 = zeros(length(SNR_list),1);
r_repeat_hierarchy0= zeros(length(SNR_list),1);

for idx = 1:SNR_len
    SNR_dB = SNR_dB_list(idx);
    SNR = SNR_list(idx);
    fprintf('SNR_dB = %.4f[%d/%d] | run %.4f s\n', SNR_dB,  idx, SNR_len,  etime(clock, t0)); 
    H=zeros(Nt,K,N_iter);
    h_BS=zeros(Nt,K,N_iter);
    array_gain_exhaustive=zeros(N_iter,K);
    array_gain_tra =zeros(N_iter,K);
    array_gain_softconv=zeros(N_iter,K);
    array_gain_repeat=zeros(N_iter,K);
    id_BS_exhaustive=zeros(N_iter,K);
    id_BS_tra=zeros(N_iter,K);
    id_BS_softconv=zeros(N_iter,K);
    id_BS_repeat=zeros(N_iter,K);
    r_far_exhaustive=zeros(N_iter,1);
    r_softconv_hierarchy=zeros(N_iter,1);
    r_tra=zeros(N_iter,1);
    r_repeat_hierarchy=zeros(N_iter,1);
    theta_DoA = zeros(N_iter,K);
    parfor i_iter = 1:N_iter  
        for k = 1:K
            theta_DoA(i_iter,k) = unidrnd(Nt);
            [H(:,k,i_iter),h_BS(:,k,i_iter)] = generate_channel(Nt,theta_DoA(i_iter,k),d,lambda);
        end 
        %遍历搜索算法
        for k = 1:K
            [array_gain_exhaustive(i_iter,k),id_BS_exhaustive(i_iter,k)] = training_exhaustive(w_far_BS,H(:,k,i_iter),SNR,Nt);
            if id_BS_exhaustive(i_iter,k)==id_BS_opt(i_iter,k)
                r_far_exhaustive(i_iter)=1;
            end
        end
        %传统分层码本
        for k = 1:K
            [array_gain_tra(i_iter,k),id_BS_tra(i_iter,k)] = training_hierarchy_tra(w_hierarchy_tra,H(:,k,i_iter),SNR,Nt);
            if id_BS_tra(i_iter,k)==id_BS_opt(i_iter,k)
                r_tra(i_iter)=1;
            end
        end
        %重复编码分层训练
        for k = 1:K
            [array_gain_repeat(i_iter,k),id_BS_repeat(i_iter,k)] = training_hierarchy_repeat(w_hierarchy_far,Nt,H(:,k,i_iter),1,SNR);
            if id_BS_repeat(i_iter,k)==id_BS_opt(i_iter,k)
                r_repeat_hierarchy(i_iter)=1;
            end
        end
        %卷积码分层训练-软译码
        for k = 1:K
            [array_gain_softconv(i_iter,k),id_BS_softconv(i_iter,k)] = training_hierarchy_softconv(Codebook,H(:,k,i_iter),SNR,Nt,conv_encoder_conf);
            if id_BS_softconv(i_iter,k)==id_BS_opt(i_iter,k)
                r_softconv_hierarchy(i_iter)=1;
            end
        end
    end
    r_tra0(idx)=sum(r_tra);
    r_far_exhaustive0(idx)=sum(r_far_exhaustive);
    r_softconv_hierarchy0(idx)=sum(r_softconv_hierarchy);
    r_repeat_hierarchy0(idx)=sum(r_repeat_hierarchy);
end

r_tra0 =r_tra0/K/N_iter ;
r_far_exhaustive0= r_far_exhaustive0/K/N_iter;
r_softconv_hierarchy0= r_softconv_hierarchy0/K/N_iter;
r_repeat_hierarchy0 =r_repeat_hierarchy0/K/N_iter;

%% plot figure

C = linspecer(4);
maker_num = 25;
figure; hold on; box on; grid on;
p1 = plot(dis_list, r_softconv_hierarchy0, '-+', 'color',C(1, :) , 'Linewidth', 1.6,'MarkerFaceColor','w');
p2 = plot(dis_list, r_tra0, '-o','color', C(2, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p3 = plot(dis_list, r_far_exhaustive0,  '-s','color', C(3, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p4 = plot(dis_list, r_repeat_hierarchy0, '-d', 'color', C(4, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
xlabel('Distance (m)', 'interpreter', 'latex', 'fontsize', 12)
ylabel('Success Rate', 'interpreter', 'latex', 'fontsize', 12)
legend([p1,p2,p3,p4],{'Proposed CBT', 'Traditional hierarchical BT','Exhaustive BT','Repetitive code-based BT'}, 'interpreter', 'latex', 'fontsize', 12);

