clear all;clc;
%参数设置
Nt = 1024;
f = 60e9;
c = 3e8;
K = 1; % 用户数量
L = 1; % 每个用户的路径数（先考虑LOS径）
lambda = c/f;
d = lambda / 2;
N_iter = 1000;
theta_min = - pi / 2;
theta_max = pi / 2;

%遍历算法BS端码本
[w_far_BS] = exhaustive_codebook(Nt);
%BS端重复码码本
[w_hierarchy_far] = hierarchy_codebook(Nt);
%BS端二分法分层码本
[w_hierarchy_tra] = hierarchy_binary_codebook(Nt);
%BS端conv code分层码本(adaptive)
setup_encoder;
[Codebook] = hierarchy_conv_codebook(Nt,conv_encoder_conf);
%% Start Simulation

t0 = clock;
SNR_dB_list=[-10:2:10];
SNR_list = 10.^(SNR_dB_list/10.);
SNR_len = length(SNR_dB_list);

r_tra = zeros(length(SNR_list),1);
r_far_exhaustive = zeros(length(SNR_list),1);
r_softconv_hierarchy = zeros(length(SNR_list),1);
r_repeat_hierarchy = zeros(length(SNR_list),1);

for idx = 1:SNR_len
    SNR_dB = SNR_dB_list(idx);
    SNR = SNR_list(idx);
    fprintf('SNR_dB = %.4f[%d/%d] | run %.4f s\n', SNR_dB,  idx, SNR_len,  etime(clock, t0)); 
    for i_iter = 1:N_iter  
        for k = 1:K
            theta_DoA(1,k) = unidrnd(Nt);
            [H(:,k),h_BS(:,k)] = generate_channel(Nt,theta_DoA(1,k),d,lambda);
        end 
        %理论上界
        for k = 1:K
            [array_gain_opt(1,k),id_BS_opt(1,k)] = training_exhaustive(w_far_BS,H(:,k),100000,Nt);
        end
        %遍历搜索算法
        for k = 1:K
            [array_gain_exhaustive(1,k),id_BS_exhaustive(1,k)] = training_exhaustive(w_far_BS,H(:,k),SNR,Nt);
            if id_BS_exhaustive(1,k)==id_BS_opt(1,k)
                r_far_exhaustive(idx)=r_far_exhaustive(idx)+1;
            end
        end
        %传统分层码本
        for k = 1:K
            [array_gain_tra(1,k),id_BS_tra(1,k)] = training_hierarchy_tra(w_hierarchy_tra,H(:,k),SNR,Nt);
            if id_BS_tra(1,k)==id_BS_opt(1,k)
                r_tra(idx)=r_tra(idx)+1;
            end
        end
        %重复编码分层训练
        [array_gain_repeat,id_BS_repeat] = training_hierarchy_repeat(w_hierarchy_far,Nt,H,K,SNR);
        for k = 1:K
            if id_BS_repeat(1,k)==id_BS_opt(1,k)
                r_repeat_hierarchy(idx)=r_repeat_hierarchy(idx)+1;
            end
        end
        %卷积码分层训练-软译码
        for k = 1:K
            [array_gain_softconv(1,k),id_BS_softconv(1,k)] = training_hierarchy_softconv(Codebook,H(:,k),SNR,Nt,conv_encoder_conf);
            if id_BS_softconv(1,k)==id_BS_opt(1,k)
                r_softconv_hierarchy(idx)=r_softconv_hierarchy(idx)+1;
            end
        end
    end
end

%% plot figure
r_tra =r_tra/K/N_iter ;
r_far_exhaustive= r_far_exhaustive/K/N_iter;
r_softconv_hierarchy= r_softconv_hierarchy/K/N_iter;
r_repeat_hierarchy =r_repeat_hierarchy/K/N_iter;

C = linspecer(4);
maker_num = 25;
figure; hold on; box on; grid on;
p1 = plot(SNR_dB_list, r_softconv_hierarchy, '-+', 'color',C(1, :) , 'Linewidth', 1.6,'MarkerFaceColor','w');
p2 = plot(SNR_dB_list, r_tra, '-o','color', C(2, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p3 = plot(SNR_dB_list, r_far_exhaustive,  '-s','color', C(3, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p4 = plot(SNR_dB_list,r_repeat_hierarchy, '-d', 'color', C(4, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
xlabel('log(Nt)', 'interpreter', 'latex', 'fontsize', 12)
ylabel('Success Rate', 'interpreter', 'latex', 'fontsize', 12)
legend([p1,p2,p3,p4],{'Proposed CBT', 'Traditional hierarchical BT','Exhaustive BT','Repetitive code-based BT'}, 'interpreter', 'latex', 'fontsize', 12);




