clear all;clc;
%参数设置
Nt = 1024;
f = 60e9;
c = 3e8;
K = 1; % 用户数量
L = 1; % 每个用户的路径数（先考虑LOS径）
lambda = c/f;
d = lambda / 2;
N_iter = 1000;
theta_min = - pi / 2;
theta_max = pi / 2;

%遍历算法BS端码本
[w_far_BS] = exhaustive_codebook(Nt);
%BS端重复码码本
[w_hierarchy_far] = hierarchy_codebook(Nt);
%BS端二分法分层码本
[w_hierarchy_tra] = hierarchy_binary_codebook(Nt);
%BS端conv code分层码本(adaptive)
setup_encoder;
[Codebook] = hierarchy_conv_codebook(Nt,conv_encoder_conf);
%BS端conv code分层码本(non-adaptive)
[w_hierarchy_conv] = hierarchy_conv_codebook1(Nt,conv_encoder_conf);

%% Start Simulation
t0 = clock;
SNR_dB_list=[-5:3:10];
SNR_list = 10.^(SNR_dB_list/10.);
SNR_len = length(SNR_dB_list);

rate_softconv_hierarchy = zeros(length(SNR_list),N_iter);
rate_softconv_hierarchy1 = zeros(length(SNR_list),N_iter);
rate_conv_hierarchy = zeros(length(SNR_list),N_iter);
rate_conv_hierarchy1 = zeros(length(SNR_list),N_iter);

for idx = 1:SNR_len
    SNR_dB = SNR_dB_list(idx);
    SNR = SNR_list(idx);
    fprintf('SNR_dB = %.4f[%d/%d] | run %.4f s\n', SNR_dB,  idx, SNR_len,  etime(clock, t0)); 
    for i_iter = 1:N_iter  
        for k = 1:K
            theta_DoA(1,k) = unidrnd(Nt);
            H=zeros(Nt,K);
            h_BS=zeros(Nt,K);
            [H(:,k),h_BS(:,k)] = generate_channel(Nt,theta_DoA(1,k),d,lambda);
        end 
        %卷积码分层训练-硬译码(adpative)
         for k = 1:K
             [array_gain_conv(1,k),id_BS_conv(1,k)] = training_hierarchy_conv(Codebook,H(:,k),SNR,Nt,conv_encoder_conf);
             rate_conv_hierarchy(idx, i_iter) =rate_conv_hierarchy(idx, i_iter)+ log2(1 + SNR * array_gain_conv(1,k));
         end
         %卷积码分层训练-硬译码(non-adpative)
         for k = 1:K
             [array_gain_conv1(1,k),id_BS_conv1(1,k)] = training_hierarchy_conv1(w_hierarchy_conv,H(:,k),SNR,Nt,conv_encoder_conf);
             rate_conv_hierarchy1(idx, i_iter) =rate_conv_hierarchy1(idx, i_iter)+ log2(1 + SNR * array_gain_conv1(1,k));
         end
        %卷积码分层训练-软译码(adpative)
        for k = 1:K
            [array_gain_softconv(1,k),id_BS_softconv(1,k)] = training_hierarchy_softconv(Codebook,H(:,k),SNR,Nt,conv_encoder_conf);
            rate_softconv_hierarchy(idx, i_iter) =rate_softconv_hierarchy(idx, i_iter)+ log2(1 + SNR * array_gain_softconv(1,k));
        end
        %卷积码分层训练-软译码(non-adpative)
        for k = 1:K
            [array_gain_softconv1(1,k),id_BS_softconv1(1,k)] = training_hierarchy_softconv1(w_hierarchy_conv,H(:,k),SNR,Nt,conv_encoder_conf);
            rate_softconv_hierarchy1(idx, i_iter) =rate_softconv_hierarchy1(idx, i_iter)+ log2(1 + SNR * array_gain_softconv1(1,k));
        end
    end
end

%% plot figure

rate_softconv_hierarchy= mean(rate_softconv_hierarchy,2);
rate_softconv_hierarchy1= mean(rate_softconv_hierarchy1,2);
rate_conv_hierarchy = mean(rate_conv_hierarchy,2);
rate_conv_hierarchy1 = mean(rate_conv_hierarchy1,2);

C = linspecer(7);
maker_num = 25;
figure; hold on; box on; grid on;
p1 = plot(SNR_dB_list, rate_softconv_hierarchy, '-+', 'color',C(1, :) , 'Linewidth', 1.6,'MarkerFaceColor','w');
p2 = plot(SNR_dB_list, rate_softconv_hierarchy1, '-*','color', C(5, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p3 = plot(SNR_dB_list, rate_conv_hierarchy,  '-s','color', C(6, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
p4 = plot(SNR_dB_list,rate_conv_hierarchy1, '-d', 'color', C(7, :), 'Linewidth', 1.6,'MarkerFaceColor','w');
xlabel('SNR (dB)', 'interpreter', 'latex', 'fontsize', 12)
ylabel('Average Rate (bit/s/Hz)', 'interpreter', 'latex', 'fontsize', 12)
legend([p1,p2,p3,p4],{'Adaptive CBT(soft)', 'Non-adaptive CBT(soft)','Adaptive CBT(hard)','Non-adaptive CBT(hard)'}, 'interpreter', 'latex', 'fontsize', 12);

















