function [array_gain,id_BS] = training_hierarchy_repeat(w_hierarchy_far,Nt,H,K,SNR)
    l1 = log2(Nt);
    array_gain=zeros(1,K);
    w_BS = zeros(Nt,2);
    id_BS=zeros(1,K);
    sigma = sqrt(1/SNR);
    %BS端码本构造
    nnt = (0:1:Nt-1)';
    %codeword_BS = linspace(-1,1,Nt);
    codeword_BS = -1+1/Nt:2/Nt:1-1/Nt;
    codebook_BS = exp(1j*pi*nnt*codeword_BS)/sqrt(Nt);
    for l=1:(l1-1)
        w_BS(:,1)=w_hierarchy_far(l,1,:);
        w_BS(:,2)=w_hierarchy_far(l,2,:);
        for k=1:K
            noise = sigma*(randn(1,2)+1i*randn(1,2))/sqrt(2);
            temp = H(:,k).'*w_BS+noise;
            A=abs(temp).^2;
            if A(1,1)>=A(1,2)
                id_BS(1,k)=id_BS(1,k)*2+0;
            end
            if A(1,1)<A(1,2)
                id_BS(1,k)=id_BS(1,k)*2+1;
            end
        end
    end
    for k=1:K
        id1 = id_BS(1,k)*2+1;
        id2 = id_BS(1,k)*2+2;
        noise = sigma*(randn(1,1)+1i*randn(1,1))/sqrt(2);
        temp1 = H(:,k).'*codebook_BS(:,id1)+noise;
        a1=abs(temp1)^2;
        noise = sigma*(randn(1,1)+1i*randn(1,1))/sqrt(2);
        temp2 = H(:,k).'*codebook_BS(:,id2)+noise;
        a2=abs(temp2)^2;
        if a1>=a2
            id_BS(1,k)=id1;
            array_gain(1,k)=abs(H(:,k).'*codebook_BS(:,id1))^2;
        end
        if a1<a2
            id_BS(1,k)=id2;
            array_gain(1,k)=abs(H(:,k).'*codebook_BS(:,id2))^2;
        end
    end
end
