function [array_gain,id_BS] = training_hierarchy_tra(w_hierarchy_tra,h,SNR,Nt)
    l0 = log2(Nt);
    w_BS = zeros(Nt,2);
    sigma = sqrt(1/SNR);
    nnt = (0:1:Nt-1)';
    codeword_BS = -1+1/Nt:2/Nt:1-1/Nt;
    codebook_BS = exp(1j*pi*nnt*codeword_BS)/sqrt(Nt);
    i=1;
    for l=1:l0
        w_BS(:,1)=w_hierarchy_tra{l}(i,:).';
        w_BS(:,2)=w_hierarchy_tra{l}(i+1,:).';
        noise = sigma*(randn(1,2)+1i*randn(1,2))/sqrt(2);
        temp =h.'*w_BS+noise;
        A=abs(temp).^2;
        gain= max(max(A));
        if l<l0
            if A(1,1)>A(1,2)
                i=i*2-1;
            else
                i=(i+1)*2-1;
            end
        else
            if A(1,1)<A(1,2)
                i=i+1;
            end
        end
    end
    id_BS=i;
    array_gain=abs(h.'*codebook_BS(:,id_BS))^2;
end