% Proposed Alamouti based SIGW near field
function X = A_SIGW_NF(Z, Phi, N, L, M, s, Amat, snum, rho, beta, rho_max, fc, d, lambda_c)
    N_sub = N/snum;
    [PolarCB_sub, label] = PolarCodeBook(N_sub, s, d, lambda_c, beta, rho, rho_max);
    S = size(PolarCB_sub, 2);
    over_sub = size(Phi, 1)/snum;
    X = zeros(N, M);
    for loop = 1:snum
        Z_sub = zeros(over_sub, M);
        for amt_idx = 1:snum
            Z_sub = Z_sub + Z((amt_idx-1)*over_sub+1:amt_idx*over_sub, :).*Amat(loop, amt_idx)./snum;
        end
        Z_sub_norm = norm(Z_sub, 'fro');
        [Hhat_sub, sup3] = SOMP(Z_sub, Phi(1:over_sub, (loop-1)*N_sub+1:loop*N_sub)*PolarCB_sub, L, S, M);
        [A, G, ~, ~] = P_SIGW(Z_sub/Z_sub_norm, Phi(1:over_sub, (loop-1)*N_sub+1:loop*N_sub)'/Z_sub_norm, ...
            PolarCB_sub(:, sup3), Hhat_sub(sup3, :), label(2, sup3), label(1, sup3), ...
            fc, d, L, 3, 20, 10, 1, 1e-8);
        X((loop-1)*N_sub+1:loop*N_sub, :) = A*G;
    end
end