% Proposed Alamouti based SOMP NF
function X = A_SOMP_NF(Z, Phi, N, L, M, s, Amat, snum, rho, beta, rho_max, d, lambda_c)
    N_sub = N/snum;
    [PolarCB_sub, ~] = PolarCodeBook(N_sub, s, d, lambda_c, beta, rho, rho_max);
    S = size(PolarCB_sub, 2);
    over_sub = size(Phi, 1)/snum;
    X = zeros(N, M);
    for loop = 1:snum
        Z_sub = zeros(over_sub, M);
        for amt_idx = 1:snum
            Z_sub = Z_sub + Z((amt_idx-1)*over_sub+1:amt_idx*over_sub, :).*Amat(loop, amt_idx)./snum;
        end
        [Hhat_sub, ~] = SOMP(Z_sub, Phi(1:over_sub, (loop-1)*N_sub+1:loop*N_sub)*PolarCB_sub, L, S, M);
        X((loop-1)*N_sub+1:loop*N_sub, :) = PolarCB_sub*Hhat_sub;
    end
end