close all; 
clear, clc;
savefile = 1;
SNR_dB = 10;  SNR_linear=10.^(SNR_dB/10.);
sigma2=1/SNR_linear;
N_iter = 10; 
%%% system parameters
N = 512; % number of beams (transmit antennas)
K = 4; % number of users
N_RF = 4; % number of RF chains
M = 256; % number of subcarriers
L = 3; % number of paths per user


fc = 100e9; % carrier frequency
R = 5;
sector = pi * 2 / 3;
fs = 100e6; % bandwidth
Q = (32:32:256)./N_RF;  % number of pilot blocks
tmax = 20e-9; % maximum of the path delay
f = zeros(1,M);
for m = 1:M
    f(m)=fc+fs/(M)*(m-1-(M-1)/2);
end
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;
eps = 1e-3;

NMSE = zeros(1,length(Q));
NMSE0 = zeros(1,length(Q));
NMSE1 = zeros(1,length(Q));
NMSE2 = zeros(1,length(Q));
NMSE3 = zeros(1,length(Q));
NMSE4 = zeros(1,length(Q));
NMSE5 = zeros(1,length(Q));
NMSE6 = zeros(1,length(Q));
NMSE7 = zeros(1,length(Q));
NMSE8 = zeros(1,length(Q));
NMSE9 = zeros(1,length(Q));
NMSE10 = zeros(1,length(Q));


%DFT    
s = 2;
D = s*N; %字典规模
row = (-(N - 1)/2:(N - 1)/2)' ;
col = -1 + 2/D : 2/D : 1 ;
DFT  =  exp( 1j*  pi * row * col ) / sqrt(N);

% Quacode
rho = 3;
beta = 1.2;
rho_max = 64;
[Polarcodebook,label] = PolarCodeBook(N, s, d, lambda_c, beta, rho,rho_max);
S = size(Polarcodebook, 2);

% spatial non-stationary
snum_max = 4;
Amat = hadamard(snum_max);

Q_len = length(Q);
t0 = clock;
for i_r = 1:Q_len
    Rmin = R;
    Rmax = R+5;
    overhead = Q(i_r);    
    error = 0; error0 = 0; error1 = 0; error2 = 0; error3 = 0; error4 = 0; error5 = 0; error6 = 0; error7 = 0; error8 = 0; error9 = 0; error10 = 0;
    for iter = 1:N_iter
        fprintf('overhead = %d[%d/%d] | iteration:[%d/%d] | run %.4f s\n', overhead, i_r, Q_len, iter, N_iter, etime(clock, t0)); 
        [H, hc, r, theta, G] = near_field_channel_ns(N, K, L, d, fc, fs, M, Rmin, Rmax,sector,1, snum_max);
        H = channel_norm(H);
        Phi = pilot_generate(N, overhead*N_RF, snum_max, Amat);
        noise = sqrt(sigma2)*(randn(overhead*N_RF,M)+1i*randn(overhead*N_RF,M))/sqrt(2); 
        
        for k = 1 : K
            Hsf =  reshape(H(k, :, :), [N, M]);    % Hsf = F*Haf
            
            % adaptive selecting matrix
            Z = Phi*Hsf + noise;
            Znorm = norm(Z, 'fro');
      
            %% Far field on-grid stationary
            [Haf_hat1, sup1] = SOMP(Z, Phi*DFT, L*2, D, M);

            %% Far field off-grid stationary
            [A2, G2] = SIGW( Z/Znorm, Phi'/Znorm, DFT(:, sup1), Haf_hat1(sup1,:), col(sup1),...
                L,  3, 20, 1, 1e-8);
            Hsf_hat2 = A2*G2;

            %% Near field on-grid stationary
            [Haf_hat3,sup3] = SOMP(Z, Phi*Polarcodebook,L*2, S, M);
            
            %% Near field off-grid stationary
            [A4, G4, r4, theta4] =P_SIGW( Z/Znorm, Phi'/Znorm, Polarcodebook(:, sup3), Haf_hat3(sup3,:), label(2, sup3), label(1, sup3), ...
            fc, d, L, 3, 20, 10, 1, 1e-8);
            Hsf_hat4 = A4*G4;

            %% Near field on-grid non-stationary

            Hhat8 = A_SOMP_NF(Z, Phi, N, L*2, M, s, Amat, 4, rho, beta, rho_max, d, lambda_c);

            %% Near field off-grid non-stationary

            Hhat10 = A_SIGW_NF(Z, Phi, N, L*2, M, s, Amat, 4, rho, beta, rho_max, fc, d, lambda_c);
            
            %% LS
            Hsf_hat5 = Hsf + ( sqrt(sigma2)*(randn(N,M)+1i*randn(N,M))/sqrt(2) );
           
            error1 = error1 + norm(Hsf - DFT*Haf_hat1,'fro')^2/norm(Hsf,'fro')^2;
            error2 = error2 + norm(Hsf - Hsf_hat2,'fro')^2/norm(Hsf,'fro')^2;
            error3 = error3 + norm(Hsf - Polarcodebook*Haf_hat3,'fro')^2/norm(Hsf,'fro')^2;
            error4 = error4 + norm(Hsf - Hsf_hat4,'fro')^2/norm(Hsf,'fro')^2;
            error5 = error5 + norm(Hsf - Hsf_hat5,'fro')^2/norm(Hsf,'fro')^2;
            error8 = error8 + norm(Hsf - Hhat8, 'fro')^2/norm(Hsf, 'fro')^2;
            error10 = error10 + norm(Hsf - Hhat10, 'fro')^2/norm(Hsf, 'fro')^2;
        end     
    end
    NMSE0(i_r) = error0/K/N_iter;
    NMSE1(i_r) = error1/K/N_iter;
    NMSE2(i_r) = error2/K/N_iter;
    NMSE3(i_r) = error3/K/N_iter;
    NMSE4(i_r) = error4/K/N_iter;
    NMSE5(i_r) = error5/K/N_iter;
    NMSE6(i_r) = error6/K/N_iter;
    NMSE7(i_r) = error7/K/N_iter;
    NMSE8(i_r) = error8/K/N_iter;
    NMSE9(i_r) = error9/K/N_iter;
    NMSE10(i_r) = error10/K/N_iter;
end

%% plot the performance
x = 1:size(Q, 2);
figure;
hold on;
plot(Q(x),10*log10(NMSE1(x)),'-*','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE2(x)),'-d','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE3(x)),'-^','Linewidth',1.5,'markersize',5,'color',[124/255 187/255 0/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE4(x)),'-s','Linewidth',1.5,'markersize',5,'color',[124/255 187/255 0/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE5(x)),'-o','Linewidth',1.5,'markersize',5,'color',[0/255 161/255 241/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE8(x)),'-<','Linewidth',1.5,'markersize',5,'color',[255/255 187/255 0/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE10(x)),'->','Linewidth',1.5,'markersize',5,'color',[255/255 187/255 0/255],'MarkerFaceColor','w');
xlabel('The pilot length');
ylabel('NMSE (dB)');
xlim([16, 64]);
xticks(16:8:64);
ylim([-20, 5]);
legend('SWOMP', 'SS-SIGW-OLS', 'P-SOMP', 'P-SIGW', 'LS', 'Proposed GP-SOMP', 'Proposed GP-SIGW');
box on;
grid on;
save(['R', num2str(R), '.mat'], 'NMSE1', 'NMSE2', 'NMSE3', 'NMSE4', 'NMSE5', 'NMSE8', 'NMSE10', 'Q');

