close all; 
clear, clc;
savefile = 1;
SNR_dB = 10;  SNR_linear=10.^(SNR_dB/10.);
sigma2=1/SNR_linear;
N_iter = 100; 
%%% system parameters
N = 512; % number of beams (transmit antennas)
K = 4; % number of users
N_RF = 4; % number of RF chains
M = 256; % number of subcarriers
L = 3; % number of paths per user

fc = 100e9; % carrier frequency
R = 5;
sector = pi * 2 / 3;
fs = 100e6; % bandwidth
Q = (32:32:512)./N_RF;  % number of pilot blocks
tmax = 20e-9; % maximum of the path delay
f = zeros(1,M);
for m = 1:M
    f(m)=fc+fs/(M)*(m-1-(M-1)/2);
end
c = 3e8;
lambda_c = c/fc;
d = lambda_c / 2;
eps = 1e-3;

NMSE = zeros(1,length(Q));
NMSE0 = zeros(1,length(Q));
NMSE1 = zeros(1,length(Q));
NMSE2 = zeros(1,length(Q));
NMSE3 = zeros(1,length(Q));
NMSE4 = zeros(1,length(Q));
NMSE5 = zeros(1,length(Q));
NMSE6 = zeros(1,length(Q));
NMSE7 = zeros(1,length(Q));
NMSE8 = zeros(1,length(Q));
NMSE9 = zeros(1,length(Q));
NMSE10 = zeros(1,length(Q));


%DFT    
s = 2;
D = s*N; %字典规模
row = (-(N - 1)/2:(N - 1)/2)' ;
col = -1 + 2/D : 2/D : 1 ;
DFT  =  exp( 1j*  pi * row * col ) / sqrt(N);

% Quacode
rho = 3;
beta = 1.2;
rho_max = 64;
[Polarcodebook,label] = PolarCodeBook(N, s, d, lambda_c, beta, rho,rho_max);
S = size(Polarcodebook, 2);

% spatial non-stationary
snum_max = 16;
Amat = hadamard(snum_max);

Q_len = length(Q);
t0 = clock;
for i_r = 1:Q_len
    Rmin = R;
    Rmax = R+395;
    overhead = Q(i_r);
    error = 0; error0 = 0; error1 = 0; error2 = 0; error3 = 0; error4 = 0; error5 = 0; error6 = 0; error7 = 0; error8 = 0; error9 = 0; error10 = 0;
    for iter = 1:N_iter
        fprintf('overhead = %d[%d/%d] | iteration:[%d/%d] | run %.4f s\n', overhead, i_r, Q_len, iter, N_iter, etime(clock, t0)); 
        
        % Wideband spatial channel
        [H, hc, r, theta, G] = near_field_channel_ns(N, K, L, d, fc, fs, M, Rmin, Rmax,sector,1, snum_max);
        H = channel_norm(H);
        Phi = pilot_generate(N, overhead*N_RF, snum_max, Amat);
        noise = sqrt(sigma2)*(randn(overhead*N_RF,M)+1i*randn(overhead*N_RF,M))/sqrt(2); 
        
        for k = 1 : K
            Hsf =  reshape(H(k, :, :), [N, M]);    % Hsf = F*Haf
            
            % adaptive selecting matrix
            Z = Phi*Hsf + noise;
            Znorm = norm(Z, 'fro');

            %% Near field on-grid non-stationary

            Hhat1 = A_SOMP_NF(Z, Phi, N, L*2, M, s, Amat, 2, rho, beta, rho_max, d, lambda_c);

            Hhat2 = A_SOMP_NF(Z, Phi, N, L*2, M, s, Amat, 4, rho, beta, rho_max, d, lambda_c);

            Hhat3 = A_SOMP_NF(Z, Phi, N, L*2, M, s, Amat, 8, rho, beta, rho_max, d, lambda_c);

            Hhat4 = A_SOMP_NF(Z, Phi, N, L*2, M, s, Amat, 16, rho, beta, rho_max, d, lambda_c);

            %% Near field off-grid non-stationary

            Hhat7 = A_SIGW_NF(Z, Phi, N, L*2, M, s, Amat, 2, rho, beta, rho_max, fc, d, lambda_c);

            Hhat8 = A_SIGW_NF(Z, Phi, N, L*2, M, s, Amat, 4, rho, beta, rho_max, fc, d, lambda_c);

            Hhat9 = A_SIGW_NF(Z, Phi, N, L*2, M, s, Amat, 8, rho, beta, rho_max, fc, d, lambda_c);

            Hhat10 = A_SIGW_NF(Z, Phi, N, L*2, M, s, Amat, 16, rho, beta, rho_max, fc, d, lambda_c);
               

            error1 = error1 + norm(Hsf - Hhat1,'fro')^2/norm(Hsf,'fro')^2;
            error2 = error2 + norm(Hsf - Hhat2,'fro')^2/norm(Hsf,'fro')^2;
            error3 = error3 + norm(Hsf - Hhat3,'fro')^2/norm(Hsf,'fro')^2;
            error4 = error4 + norm(Hsf - Hhat4,'fro')^2/norm(Hsf,'fro')^2;
            error7 = error7 + norm(Hsf - Hhat7, 'fro')^2/norm(Hsf, 'fro')^2;
            error8 = error8 + norm(Hsf - Hhat8, 'fro')^2/norm(Hsf, 'fro')^2;
            error9 = error9 + norm(Hsf - Hhat9, 'fro')^2/norm(Hsf, 'fro')^2;
            error10 = error10 + norm(Hsf - Hhat10, 'fro')^2/norm(Hsf, 'fro')^2;
        end     
    end
    NMSE0(i_r) = error0/K/N_iter;
    NMSE1(i_r) = error1/K/N_iter;
    NMSE2(i_r) = error2/K/N_iter;
    NMSE3(i_r) = error3/K/N_iter;
    NMSE4(i_r) = error4/K/N_iter;
    NMSE5(i_r) = error5/K/N_iter;
    NMSE6(i_r) = error6/K/N_iter;
    NMSE7(i_r) = error7/K/N_iter;
    NMSE8(i_r) = error8/K/N_iter;
    NMSE9(i_r) = error9/K/N_iter;
    NMSE10(i_r) = error10/K/N_iter;
end

%% plot the performance
x = 1:size(Q, 2);
figure;
hold on;
plot(Q(x),10*log10(NMSE1(x)),'-*','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE2(x)),'-d','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE3(x)),'-^','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE4(x)),'-s','Linewidth',1.5,'markersize',5,'color',[246/255 83/255 20/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE7(x)),'-*','Linewidth',1.5,'markersize',5,'color',[0/255 161/255 241/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE8(x)),'-d','Linewidth',1.5,'markersize',5,'color',[0/255 161/255 241/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE9(x)),'-^','Linewidth',1.5,'markersize',5,'color',[0/255 161/255 241/255],'MarkerFaceColor','w');
plot(Q(x),10*log10(NMSE10(x)),'-s','Linewidth',1.5,'markersize',5,'color',[0/255 161/255 241/255],'MarkerFaceColor','w');
xlabel('The pilot length');
ylabel('NMSE (dB)');
ylim([-16, 6]);
legend('GP-SOMP, Ns=2','GP-SOMP, Ns=4','GP-SOMP, Ns=8','GP-SOMP, Ns=16','GP-SIGW, Ns=2','GP-SIGW, Ns=4','GP-SIGW, Ns=8','GP-SIGW, Ns=16');
box on;
grid on;
save('subarray.mat', 'NMSE1', 'NMSE2', 'NMSE3', 'NMSE4', 'NMSE7', 'NMSE8', 'NMSE9', 'NMSE10', 'Q');

