% generate the on-grid spatial non-stationary
function Nmat = nonstat_generate_on(N, snum)
    if mod(N, snum) ~= 0
        error('mod(N, snum) should be 0\n');
    else
        mask_float = rand(snum, 1);
        mask_float = mask_float + max((0.51 - max(mask_float)), 0).*ones(size(mask_float));
        mask = int64(mask_float>0.5);
        Nmat = double(kron(mask, int64(ones(N/snum, 1))));
    end
    Nmat = diag(Nmat);
end