function W = pilot_generate(N, overhead, snum_max, Amat)
    W_root = ((rand(N, overhead/snum_max)>0.5)*2 - 1)/sqrt(N);
    W = zeros(N, overhead);
    for loop = 1:size(Amat, 1)
        W_mask = kron(Amat(:, loop), double(ones(N/snum_max, overhead/snum_max)));
        W_buffer = W_root.*W_mask;
        W(:, (loop - 1)*overhead/snum_max + 1:loop*overhead/snum_max) = W_buffer;
    end
    W = W';
end

