function w_est = estimateBandwidth(y1, W1, P, sigma2)
    [NRx, Ncomb] = size(W1); 
    w_arr = 0.05:0.02:0.8; 
    Nw = length(w_arr); 

    % spatial correlation = sinc(w n)
    logL = zeros(Nw, 1); 
    for idx = 1:Nw
        w = w_arr(idx); 
        Cxmat = P*(W1')*toeplitz(sinc(w*(0:NRx-1)))*W1; 
        Cymat = Cxmat + sigma2*eye(Ncomb); 
        logL(idx) = real(-y1'*(Cymat\y1) - log(det(Cymat))); 
    end

    [~, imax] = max(logL); 
    w_est = w_arr(imax); 


end



