function w_est = estimateBandwidth2D(y1, W1, V1, A, P, sigma2)
    [NRx, Ncomb] = size(W1); 
    [NTx, ~] = size(V1); 
    
%     Nh = NRx*NTx; 

%     A = zeros(Ncombiner, Nh); 
%     for idx = 1:Ncombiner
%         A(idx, :) = kron(V(:,idx).', W(:,idx)'); 
%     end

    w_arr = 0.05:0.02:0.8; 

    Nw = length(w_arr); 
    logL = zeros(Nw, 1); 
    for idx = 1:Nw
        wr = w_arr(idx); 
        wt = wr; 

        Rt = toeplitz(sinc(wt*(0:NTx-1))); 
        Rr = toeplitz(sinc(wr*(0:NRx-1))); 
        Cxmat = P*A*(kron(Rt, Rr))*A';      % Each element of H is of energy 1.  
        Cymat = Cxmat + sigma2*eye(Ncomb); 

        logL(idx) = real(-y1'*(Cymat\y1) - log(det(Cymat))); 
    end

    [~, imax] = max(logL); 
    w_est = w_arr(imax); 


end



