function I = estimateIntervals(data, nI)
% Return nI disjoint intervals according to the energy distribution of data.  

    N = length(data); % map to interval [0, 1] first. 

    [MaxVal, iMaxVal] = max(data); 
    [minVal, iMinVal] = min(data); 


    [pks, locs, w, p] = findpeaks(data,1:(N),'Annotate','extents'); 


    % findpeaks(data,1:(N),'Annotate','extents');

    [~, order] = sort(w, 'descend'); 

    sel = locs(order(1:nI)); 
    wsel = w(order(1:nI)); 
    
    I = cell(nI, 1); 
    for idx = 1:nI
        I{idx} = [2*((sel(idx)-1)/N)-1, 0, 0.4, -1]; 
    end

    % postProcessing
    for idx = 1:nI
        interval = I{idx}; 

        if interval(1) - interval(3) < -1
            interval(3) = interval(3)*0.7; 
            interval(1) = -1 + interval(3)/2; 
        end

        if interval(1) + interval(3) > 1
            interval(3) = interval(3)*0.7;
            interval(1) = 1-interval(3)/2; 
        end

        I{idx} = interval; 
    end

end
