function [ECpswf, ECa, aDoF, Nyq] = getPSWFBound(omegaSupport, normalizedL, Gamma, SNR)
% ===   INPUT  ====
% omegaSupport:     Lebesgue measure of the normalized k-domain support. 
% normalizedL:      L/λ
% Gamma:            BW parameter in the normalized k-domain
% SNR:              P_T/σ^2
% ===   OUTPUT  ===
% ECpswf:           PSWF ergodic capacity upper bound (normalized)
% ECa:              asymptotic ergodic capacity upper bound (normalized)
% aDoF:             asymptotic DoF
% Nyq:              Nyquist number returned by the PSWF evaluator. 

normalizedL     = min(normalizedL, 1/Gamma); 
cpswf           = pi*(omegaSupport)*normalizedL/2; 
NyqNumberEst    = ceil(2*cpswf/pi);
nmax            = ceil(max(40, 2.5*NyqNumberEst));
numerical_h     = 0.01; 

[mu, Nyq]       = get1DPSWFEigenvalus(cpswf, nmax, numerical_h); 
ECpswf          = sum(log(1+SNR*mu))/log(1+SNR); 

aDoF            = omegaSupport*normalizedL; 
f               = log(SNR)/(2*pi^2); 
ECa             = aDoF + 0*log(2*pi*aDoF)*f; 
    

end

