% ================================== % 
% 
%   This file plots the performance of BW estimator from the generated
%   .MAT files. 
%   
%
%
% ================================== % 
clear all; close all; clc; 



d0 = load('results/Estimators/MIMO_N12_SNR0_wComb/data.mat','BWs','StdBWs', 'Ncombiner_arr'); 
d1 = load('results/Estimators/MIMO_N12_SNR10_wComb/data.mat','BWs','StdBWs'); 
d2 = load('results/Estimators/MIMO_N12_SNR20_wComb/data.mat','BWs','StdBWs'); 
Ncombiner_arr = d0.Ncombiner_arr; 

%%
saveFigs = false; 

set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    14);
set(0,'DefaultAxesFontSize',    12);
set(0,'DefaultLineLineWidth',   1.4);
set(0,'defaultfigurecolor',     'w');

figure(1); 
errorbar(Ncombiner_arr, d0.BWs(:,1), d0.StdBWs(:,1), 'Marker','square', 'LineWidth',1.0, 'Color','r'); hold on; grid on; box on; 
errorbar(Ncombiner_arr, d1.BWs(:,1), d1.StdBWs(:,1), 'Marker','v', 'LineWidth', 1.0, 'Color','b'); 
errorbar(Ncombiner_arr, d2.BWs(:,1), d2.StdBWs(:,1), 'Marker','<', 'LineWidth', 1.0, 'Color', [0.6 0.0 0.7]); 
line([Ncombiner_arr(1), Ncombiner_arr(end)], [0.15, 0.15], 'linestyle', '--', 'color', 'k'); 

xlabel('Number of pilots'); ylabel('Estimated BW'); 
legend({'SNR=$0\,{\rm dB}$', 'SNR=$10\,{\rm dB}$', 'SNR=$20\,{\rm dB}$', 'True BW'}, 'Interpreter','latex'); 









