## Paper Information

This simulation code package is mainly used to reproduce the results of the following paper [1]:

[1] **J. Zhu**, V. Y. F. Tan, and L. Dai, "MIMO capacity analysis and channel estimation for electromagnetic information theory," *IEEE J. Sel. Areas Commun.*, early access, Jan. 2026.  

------

**If you use this simulation code package in any way, please cite the original paper [1] above.** 

The author in charge of this simulation code package is: **Jieao Zhu** (email:  [zja21@mails.tsinghua.edu.cn]()  ; johnzja@qq.com).

Reference: We highly respect reproducible research, so we try to provide the simulation codes for our published papers (more information can be found at: 
http://oa.ee.tsinghua.edu.cn/dailinglong/publications/publications.html). 

Please note that the MATLAB R2025a is used for this simulation code package, and there may be some incompatibility problems among different MATLAB versions.  

Copyright reserved by the Broadband Communications and Signal Processing Laboratory (led by Dr. Linglong Dai), Department of Electronic Engineering, Tsinghua University, Beijing 100084, China.  

------

Abstract of the paper: 

**Abstract**—Electromagnetic information theory (EIT) is an interdisciplinary subject that serves to integrate deterministic electromagnetic theory with stochastic Shannon's information theory. Existing EIT analysis operates in the continuous space domain, which is not aligned with the practical algorithms working in the discrete space domain. This mismatch leads to a significant difficulty in application of EIT methodologies to practical discrete space systems, which is called as the discrete-continuous gap in this paper. To bridge this gap, we establish the discrete-continuous correspondence with a prolate spheroidal wave function (PSWF)-based ergodic capacity analysis framework. Specifically, we state and prove some discrete-continuous correspondence lemmas to establish a firm theoretical connection between discrete information-theoretic quantities to their continuous counterparts. With these lemmas, we apply the PSWF ergodic capacity bound to advanced MIMO architectures such as continuous-aperture MIMO (CAP-MIMO) and extremely large-scale MIMO (XL-MIMO). From this PSWF capacity bound, we discover the capacity saturation phenomenon both theoretically and empirically. Although the growth of MIMO performance is fundamentally limited in this EIT-based analysis framework, we reveal new opportunities in MIMO channel estimation by exploiting the EIT knowledge about the channel. Inspired by the PSWF capacity bound, we utilize continuous PSWFs to improve the pilot design of discrete MIMO channel estimators, which is called as the PSWF channel estimator (PSWF-CE). Simulation results demonstrate improved performance of the proposed PSWF-CE, compared to traditional minimum mean squared error (MMSE) and compressed sensing-based estimators. 

------



## MATLAB Code Usage Description

| MATLAB script                 | Description                              | Paper figure   |
| ----------------------------- | ---------------------------------------- | -------------- |
| ./simDoFandCapacity_HMIMO.m   | This script simulates the ergodic capacity of the colored scattering MIMO channel [R1] in the H-MIMO regime, where the Tx/Rx antenna aperture is fixed while the number of antennas $\to\infty$. | Figure 2       |
| ./simDoFandCapacity_XLMIMO.m  | This script simulates the ergodic capacity of the colored scattering MIMO channel [R1] in the XL-MIMO regime, where the antenna aperture $\to\infty$. | Figure 3       |
| ./simMIMO_CE_wrt_Ncomb.m      | This script simulates the PSWF-CE MIMO channel estimator performance, where the number of pilots $N_{\rm P}$ is scanned. SNR and channel generation method can be configured by altering `channelGenerationMethod` and `P`. | Figure 6, 7, 9 |
| ./simMIMO_CE_wrt_SNR.m        | This script simulates the performance of PSWF-CE MIMO channel estimator, where the SNR $P_{\rm T}/\sigma_z^2$ is scanned. Channel generation method and pilot overhead can be configured by altering `channelGenerationMethod` and `Ncombiner`. | Figure 5, 8    |
| ./simMIMO_CE_wrt_pilotRatio.m | This script simulates the performance of PSWF-CE MIMO channel estimator, where the pilot allocation ratio $\alpha=N_{\rm P,1}/(N_{\rm P,1}+N_{\rm P,2})$ and the total number of pilots $N_{\rm P}$ are scanned. | Figure 10      |

[R1] W. Nam, D. Bai, J. Lee, and I. Kang, “On the capacity limit of wireless channels under colored scattering,” *IEEE Trans. Inf. Theory*, vol. 60, no. 6, pp. 3529–3543, Apr. 2014. 

------

Enjoy the reproducible research! 

