% ======================================================================================= %
% 
%   This script evaluates the shifted 1D-PSWFs within arbitrary point in [-1,1].  
% 
%  % Author: Jieao Zhu 
% 
% ======================================================================================= %

clear; close all; clc; 

set(0,'DefaultLineMarkerSize',  6);
set(0,'DefaultTextFontSize',    14);
set(0,'DefaultAxesFontSize',    12);
set(0,'DefaultLineLineWidth',   1.4);
set(0,'defaultfigurecolor',     'w');

W1           = 4; 
Wc          = 2; % Up-conversion frequency parameter 
b1           = 1; 
a1           = -1; 
h           = 0.002; 
saveFigs    = true; 

t_arr = (-3+h/2:h:3-h/2); 
Nmax = 6; 
[lambdas1, phi_q1] = getShifted1DPSWFs(t_arr, a1, b1, Wc, W1, h, ceil(3*Nmax+1), Nmax); 


W2 = 2; 
b2 = 1; 
a2 = -1; 
[lambdas2, phi_q2] = getShifted1DPSWFs(t_arr, a2, b2, Wc, W2, h, ceil(3*Nmax+1), Nmax); 


%% Visualization 
C = linspecer(Nmax); 

fig1 = figure(1); 
set(fig1, 'Position', [194, 173, 1111, 603]); 


%% PSWF group 1 
subplot(2, 2, 1); 
legends = {}; 

for idx = 1:Nmax
    plot(t_arr, phi_q1(idx, :), 'Color', C(idx, :)); hold on; grid on; box on; 
    legends{idx} = sprintf('$\\psi_{%d}(t)$', idx-1); 
    funcEnergy = sum(phi_q1(idx, :).^2*h); 
    fprintf('PSWF L2 Energy=%.3f\n', funcEnergy); 
end

phi_max = max(phi_q1, [], 'all');
phi_min = min(phi_q1, [], 'all'); 

line([a1,a1], [phi_min, phi_max], 'Color', 'k', 'LineStyle', '--'); 
line([b1,b1], [phi_min, phi_max], 'Color', 'k', 'LineStyle', '--'); 

legends{Nmax+1} = 'a'; 
legends{Nmax+2} = 'b'; 
legend(legends, 'Location', 'east', 'Interpreter','latex'); 

xlabel("Variable $x\in{A}$", 'Interpreter', 'latex'); 
ylabel('PSWF value'); 
title('WT=8'); 

subplot(2, 2, 2); 
Ndisp = min([20, 3*Nmax+1]); 
stem((0:Ndisp-1).', lambdas1(1:Ndisp), 'Color', 'b'); grid on; 
xlabel(' Eigenvalue index n', 'FontSize', 14); 
ylabel('$\lambda_n$', 'Interpreter', 'latex', 'FontSize', 14); 
ylim([0, 1.2]); 
title('WT=8'); 

%% PSWF group 2 
subplot(2, 2, 3); 
legends = {}; 

for idx = 1:Nmax
    plot(t_arr, phi_q2(idx, :), 'Color', C(idx, :)); hold on; grid on; box on; 
    legends{idx} = sprintf('$\\psi_{%d}(t)$', idx-1); 
    funcEnergy = sum(phi_q2(idx, :).^2*h); 
    fprintf('PSWF L2 Energy=%.3f\n', funcEnergy); 
end

phi_max = max(phi_q2, [], 'all');
phi_min = min(phi_q2, [], 'all'); 

line([a2,a2], [phi_min, phi_max], 'Color', 'k', 'LineStyle', '--'); 
line([b2,b2], [phi_min, phi_max], 'Color', 'k', 'LineStyle', '--'); 

legends{Nmax+1} = 'a'; 
legends{Nmax+2} = 'b'; 
legend(legends, 'Location', 'east', 'Interpreter','latex'); 

xlabel("Variable $x\in{A}$", 'Interpreter', 'latex'); 
ylabel('PSWF value'); 
title('WT=4'); 

subplot(2, 2, 4); 
Ndisp = min([20, 3*Nmax+1]); 
stem((0:Ndisp-1).', lambdas2(1:Ndisp), 'Color', 'b'); grid on; 
xlabel(' Eigenvalue index n', 'FontSize', 14); 
ylabel('$\lambda_n$', 'Interpreter', 'latex', 'FontSize', 14); 
ylim([0, 1.2]); 
title('WT=4'); 

if saveFigs
    exportgraphics(fig1, 'results/PSWFGraphics/PSWF_compare.pdf', 'ContentType', 'vector'); 
    fprintf('Figure saved.\n'); 
end

fprintf('End of this script.\n'); 
