% ============================== % 
% This file studies the colored fading channel model. 
% model. 
% 
% ============================== % 
clear; close all; clc;

addpath('algs/'); 
addpath('utils/');
fc = 3.5e9; 
c = physconst('lightspeed'); 
lambda = c/fc; 
k0 = 2*pi/lambda; 


%% Get channel and precode. 

L = 20; 

N_test = 5; 


P = 10;
sigma2 = 1; 


MIMO_params = setup("SymmetricULAwithFixedK", fc, L);           % MIMO setup


maxRate = zeros(N_test, 1);
lbRate = zeros(N_test, 1); 

for i_test = 1:N_test
    H = getChannel(MIMO_params, "ColoredAngularCorrelation"); 
    
    fprintf('Channel Fnorm2 = %.3f / normalized = %.3f NT = %d ', ...
        norm(H, 'fro')^2, norm(H, 'fro')^2/(MIMO_params.TxArray.N*MIMO_params.RxArray.N), MIMO_params.TxArray.N); 

    % Precode for MIMO channel H. 
    P = 10;
    sigma2 = 1; 
    [W, U, p] = waterFilling(H, P, 1); 

    fprintf('Pconsump = %.3f ', sum(p)); 
    
    maxRate(i_test) = log(real(det(eye(MIMO_params.RxArray.N)+(1/sigma2)*(H*W*diag(p)*W'*H'))))/log(1+P/sigma2); 
    lbRate(i_test) = log(real(det(eye(MIMO_params.RxArray.N)+(P/(MIMO_params.TxArray.N*sigma2))*(H*H'))))/log(1+P/sigma2); 

    fprintf('Rates = (%.3f, %.3f)\n', maxRate(i_test), lbRate(i_test)); 
end


