function W = getCombiner(SIMO_params, Intervals, Ncombiner, method, thres)

    NRx = SIMO_params.RxArray.N; 

    if method == "PSWF"
        cntBasisRx = 0; 
        selDSSRx = zeros(NRx, 1); 
        
        Lambdas = []; 
        for idx = 1:length(Intervals)
            kx = Intervals{idx}(1); 
            rx = Intervals{idx}(3); 
    
            [DSS, Lambda] = getDiscreteSlepianSequence(NRx, kx-rx, kx+rx); 
            
            for ii = 1:NRx
                if Lambda(ii) >= thres
                    selDSSRx(:, cntBasisRx+1) = DSS(:,ii); 
                    cntBasisRx = cntBasisRx + 1;
                    Lambdas = [Lambdas, Lambda(ii)]; 
                end
            end
        end

        if cntBasisRx >= Ncombiner
            [~, order] = sort(Lambdas, 'descend'); 

            p = randperm(cntBasisRx, Ncombiner); 
            % p = order(1:Ncombiner); 
            W = selDSSRx(:, p); 
        else
            % randX = (randn([NRx, Ncombiner-cntBasisRx]) + 1j*randn([NRx, Ncombiner-cntBasisRx]))/sqrt(2); 
            % randX = randX ./ vecnorm(randX); 
            randChosen = randi([1, cntBasisRx], [1, Ncombiner-cntBasisRx]); 
            W = [selDSSRx, selDSSRx(:, randChosen)]; 
            % W = W(:, randperm(Ncombiner)); 
        end
    

    elseif method == "Random"
        randX = (randn([NRx, Ncombiner]) + 1j*randn([NRx, Ncombiner]))/sqrt(2); 
        W = randX ./ vecnorm(randX); 
        
    else
        error('Method %s does not exist. ', method); 
    end

end

