function X = pilotGeneration(MIMO_params, method)

    Npilot = MIMO_params.Npilot; 
    

    if method == "Random"
        NTx = MIMO_params.TxArray.N; 
        randX = (randn([NTx, Npilot]) + 1j*randn([NTx, Npilot]))/sqrt(2); 
        randX = randX ./ vecnorm(randX); 
        X = sqrt(MIMO_params.P_channelEst)*randX; 

    elseif method == "PSWF"
        NTx = MIMO_params.TxArray.N; 
        thres = 0.01; 
    
        cntBasisTx = 0; 
        selDSSTx = zeros(NTx, 1); 
        for idx = 1:3
            kx = MIMO_params.TxArray.RegionsTx{idx}(1); 
            rx = MIMO_params.TxArray.RegionsTx{idx}(3); 
    
            [DSS, Lambda] = getDiscreteSlepianSequence(NTx, kx-rx, kx+rx); 
            
            for ii = 1:NTx
                if Lambda(ii) >= thres
                    selDSSTx(:, cntBasisTx+1) = DSS(:,ii); 
                    cntBasisTx = cntBasisTx + 1;
                end
            end
        end
    
%         selDSSRx = zeros(NTx, 1); 
%         cntBasisRx = 0; 
%         for idx = 1:3
%             kx = MIMO_params.RxArray.RegionsRx{idx}(1); 
%             rx = MIMO_params.RxArray.RegionsRx{idx}(3); 
%     
%             [DSS, Lambda] = getDiscreteSlepianSequence(NRx, kx-rx, kx+rx); 
%             
%             for ii = 1:NRx
%                 if Lambda(ii) >= thres
%                     selDSSRx(:, cntBasisRx+1) = DSS(:,ii); 
%                     cntBasisRx = cntBasisRx + 1;
%                 end
%             end
%         end

        if cntBasisTx >= Npilot
            p = randperm(cntBasisTx, Npilot); 
            X = sqrt(MIMO_params.P_channelEst)*selDSSTx(:, p); 
        else
            randX = (randn([NTx, Npilot-cntBasisTx]) + 1j*randn([NTx, Npilot-cntBasisTx]))/sqrt(2); 
            randX = randX ./ vecnorm(randX); 

            X = sqrt(MIMO_params.P_channelEst)*[selDSSTx, randX]; 
        end

    else
        error('fuck'); 
    end


end
