function [Kernel_J0,Kernel_exp,Kernel_SV] = Kernal_generate_func(f,N1,N2,d)

% Kernel_SV: Kernel generated by SV channel
% Kernel_J0: Kernel generated by Bessel function
% Kernel_exp: Kernel generated by exponential function
% f: frequency
% N: Antenna number
% d: Anetann spacing

N = N1*N2;

lambda = 3e8/f;   % Wavelength

eta = lambda/2/pi;
n_azi = ( -(N1-1)/2:1:(N1-1)/2 )';
n_ele = ( -(N2-1)/2:1:(N2-1)/2 )';
kernel_azi = exp(-0.096*pi*abs(d*n_azi - d*n_azi').^2/eta^2);
kernel_ele = exp(-0.096*pi*abs(d*n_ele - d*n_ele').^2/eta^2);
Kernel_exp = kron(kernel_azi, kernel_ele);

kernel_azi = besselj(0,0.85*abs(d*n_azi - d*n_azi')/eta);
kernel_ele = besselj(0,0.85*abs(d*n_ele - d*n_ele')/eta);
Kernel_J0 = kron(kernel_azi, kernel_ele);

Rep = 1000;
Kernel_SV = zeros(N,N);   % CDL kernel
for rp = 1:Rep
    h = SV_channel(f,N1,N2,d);
    Kernel_SV = Kernel_SV + h*h';
end
Kernel_SV = Kernel_SV/Rep;


end

