function h = SV_channel(f,N1,N2,d)

lambda = 3e8/f;   % Wavelength

N = N1*N2;

h = zeros(N,1);

Angle_spr = 5/180*pi;   % Angle spread
Delay_spr = 30e-9;

L =  23;       % Number of paths
R =  20;        % Number of rays

for l = 1: L
    theta_l = pi*rand();

    phi_l = pi*rand();

    for r = 1:R
        theta_l_r = theta_l + 2*(rand()-0.5)*Angle_spr;
        phi_l_r = phi_l + 2*(rand()-0.5)*Angle_spr;

        a_y = [0:1:N1-1]'*sin(theta_l_r)*sin(phi_l_r)*2*pi/lambda*d;
        a_x = [0:1:N2-1]'*cos(phi_l_r)*2*pi/lambda*d;

        a_y = exp(1j*a_y);
        a_x = exp(1j*a_x);

        a = kron(a_y, a_x);

        gain_l_r = 1/sqrt(2)*(randn()+1j*randn());
        
        gain_l_r = gain_l_r * exp(1j*2*pi/lambda*3e8*Delay_spr*rand());

        h = h + gain_l_r*a;
    end
end
h = h/sqrt(L*R);


end