
N = 100;
K = complex(randn(N), randn(N));
K = K * K' + 1e-4 * eye(N);  


K_inv_direct = inv(K);
logdet_direct = log(det(K));

[K_inv_chol, logdet_chol] = complex_cholesky_ops(K);


inv_error = norm(K_inv_direct - K_inv_chol, 'fro') / norm(K_inv_direct, 'fro');
logdet_error = abs(logdet_direct - logdet_chol) / abs(logdet_direct);
fprintf('逆矩阵相对误差: %.2e\n', inv_error);
fprintf('对数行列式相对误差: %.2e\n', logdet_error);

function [K_inv, logdet_K] = complex_cholesky_ops(K)

    L = chol(K, 'lower');

    L_inv = L \ eye(size(L));
    
    K_inv = L_inv' * L_inv;

    logdet_K = 2 * sum(log(diag(L)));
end