%% Visualization.
load('results/GPR-CDL_moretime_v20.mat');
T_arr = (linspace(0, simPar.Ts * (simPar.T_pre - 1), simPar.T_pre).') * 1000;
set(0,'DefaultLineMarkerSize',  4);
set(0,'DefaultTextFontSize',    14);
set(0,'DefaultAxesFontSize',    12);
set(0,'DefaultLineLineWidth',   1.4);
set(0,'defaultfigurecolor',     'w');
figure('color', [1 1 1]);
% 颜色矩阵
C = [   0.0000    0.0000    0.0000
        0.2000    0.4000    0.8494
        0.3718    0.7176    0.4000
        1.0000    0.5482    0.1000
        0.9650    0.1110    0.1330
        0.8650    0.1110    0.8330
        0.0000    0.0000    0.9000
    ]; 
NMSE_LSTM = [-9.01, -9.15, -8.85, -8.38, -7.69];
NMSE_Transformer = [-10.27, -10.71, -10.08, -9.15,-7.97];
% 绘制每条曲线
p1 = plot(T_arr, pow2db(NMSE_LS_mean),       'Marker', '+', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(1, :), 'DisplayName', 'No prediction');
hold on;
p2 = plot(T_arr, NMSE_LSTM, 'Marker', '*', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(3, :), 'DisplayName', 'LSTM');
p3 = plot(T_arr, pow2db(NMSE_AR_mean),       'Marker', 'd', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(4, :), 'DisplayName', 'AR');
p4 = plot(T_arr, pow2db(NMSE_Prony_mean),    'Marker', 'o', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(7, :), 'DisplayName', 'PVEC');
p6 = plot(T_arr, pow2db(NMSE_singleKernelGPR_mean), 'Marker', 's', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(6, :), 'DisplayName', 'STEM kernel learning');
p7 = plot(T_arr, pow2db(NMSE_mixedKernelGPR_mean), 'Marker', '>', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(5, :), 'DisplayName', 'GEM kernel learning');
p8 = plot(T_arr, NMSE_Transformer, 'Marker', '<', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(2, :), 'DisplayName', 'Transformer');
% 添加网格、标签和图例
grid on;
xlabel('Time (ms)', 'Interpreter','latex');
ylabel('NMSE (dB)', 'Interpreter','latex');
legend([p1, p3, p4, p2, p8, p6, p7], 'Location', 'best'); % 使用每个 plot 返回的句柄
set(gca,'FontName','Times New Roman');



figure('color', [1 1 1]);
% 颜色矩阵
C = [   0.0000    0.0000    0.0000
        0.2000    0.4000    0.8494
        0.3718    0.7176    0.4000
        1.0000    0.5482    0.1000
        0.9650    0.1110    0.1330
        0.8650    0.1110    0.8330
        0.0000    0.0000    0.9000
    ]; 
% 绘制每条曲线
% p1 = plot(T_arr, (Rate_LS_mean),       'Marker', 'd', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(1, :), 'DisplayName', 'no prediction LS');
p1 = plot(T_arr, (Rate_CSI_mean),       'LineStyle', '-.', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(1, :), 'DisplayName', 'Perfect CSI');
hold on;
p2 = plot(T_arr, (Rate_MMSE_ISO_mean), 'Marker', 's', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(3, :), 'DisplayName', 'no learning EM');
p3 = plot(T_arr, (Rate_AR_mean),       'Marker', 'o', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(4, :), 'DisplayName', 'AR(5)');
p4 = plot(T_arr, (Rate_Prony_mean),    'Marker', 'o', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(7, :), 'DisplayName', 'Prony');
p6 = plot(T_arr, (Rate_singleKernelGPR_mean), 'Marker', '>', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(5, :), 'DisplayName', 'EM kernel learning');
p7 = plot(T_arr, (Rate_mixedKernelGPR_mean), 'Marker', '>', 'MarkerSize', 6, 'MarkerFaceColor','w', 'Color', C(6, :), 'DisplayName', 'GEM kernel learning');
% 添加网格、标签和图例
grid on;
xlabel('time (ms)', 'Interpreter','latex');
ylabel('Achievable rate(bit/s/Hz)', 'Interpreter','latex');
legend([p1, p2, p3, p4, p6, p7], 'Location', 'best'); % 使用每个 plot 返回的句柄
set(gca,'FontName','Times New Roman');
% Problem: when mu is large, why is the correlation decaying?
%% Save files
save('results/v200_SNRLOW.mat');
