function [K_inv, logdet_K] = complex_cholesky_ops(K)
    % 输入: Hermitian 正定复矩阵 K (N x N)
    % 输出: 逆矩阵 K_inv 和对数行列式 logdet_K
    
    % Cholesky 分解 (K = L * L')
    L = chol(K, 'lower');
    
    % 计算 L^{-1} (前代法)
    L_inv = L \ eye(size(L));
    
    % 计算 K^{-1} = (L^{-1})' * L^{-1}
    K_inv = L_inv' * L_inv;
    
    % 计算对数行列式 ln(det(K)) = 2 * sum(ln(diag(L)))
    logdet_K = 2 * sum(log(diag(L)));
end