function [E34, E43] = getActionMatrices()

    % E34 action matrix 
    E34 = zeros(16); 
    Pos_ni = [3, 4;  7, 8;     11, 12;  15, 16]; 
    Pos_pi = [13, 9; 14, 10;   15, 11;  16, 12]; 
    
    for idx = 1:4 
        k           = Pos_ni(idx, 1); 
        ell         = Pos_ni(idx, 2); 
        E34(k, ell) = E34(k, ell) + (-1i); 
    end
    
    for idx = 1:4 
        k           = Pos_pi(idx, 1); 
        ell         = Pos_pi(idx, 2); 
        E34(k, ell) = E34(k, ell) + (+1i); 
    end
    
    
    % E43 action matrix 
    E43 = zeros(16); 
    Pos_ni = Pos_ni(:, [2, 1]); 
    Pos_pi = Pos_pi(:, [2, 1]); 
    for idx = 1:4 
        k           = Pos_ni(idx, 1); 
        ell         = Pos_ni(idx, 2); 
        E43(k, ell) = E43(k, ell) + (-1i); 
    end
    
    for idx = 1:4 
        k           = Pos_pi(idx, 1); 
        ell         = Pos_pi(idx, 2); 
        E43(k, ell) = E43(k, ell) + (+1i); 
    end


end
